package com.yeejoin.amos.patrol.business.dao.repository;

import java.util.List;

import com.yeejoin.amos.patrol.dao.entity.RoutePoint;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.yeejoin.amos.patrol.dao.entity.PointClassify;

@Repository("iPointClassifyDao")
public interface IPointClassifyDao extends BaseDao<PointClassify, Long> {

	@Modifying
	@Transactional
	@Query(value = "select * from p_point_classify where point_id = ?1 and is_delete = 0", nativeQuery = true)
	List<PointClassify> getPointClassifyByPointId(long id);

	@Query(value = "SELECT * FROM `p_point_classify` where point_id = ?1 and equipment_id = ?2", nativeQuery = true)
	List<PointClassify> queryByPointIdAndEquipmentId(Long pointId, String equipmentId);

	@Modifying
	@Transactional
	@Query(value = "select * from p_point_classify where name = ?1", nativeQuery = true)
	List<PointClassify> getPointClassifyByName(String classifyName);

	@Modifying
	@Transactional
	@Query(value = "delete from p_point_classify where point_id in (?1)", nativeQuery = true)
	void deleteByPointId(List<Long> pointIds);

	/**
	 * 根据原始id逻辑删除
	 * @param id 原始id
	 */
	@Modifying
	@Transactional
	@Query(value = "UPDATE p_point_classify SET is_delete = 1  WHERE original_id = (?1)", nativeQuery = true)
	void deleteByOriginalId(String id);


	/**
	 * 根据原始id查询
	 * @param id 原始id
	 * @return List<PointClassify> 返回
	 */
	@Query(value = "select * from p_point_classify  WHERE original_id = (?1) and is_delete =0", nativeQuery = true)
	List<PointClassify> selectByOriginalId(String id);

	PointClassify findByOriginalId(String originalId);



	@Query(value = "select * from p_point_classify where point_id = ?1 and code = ?2 and is_delete = 0   ", nativeQuery = true)
	PointClassify getPointClassifyByPointIdandcode(long id,String code);
}
