package com.yeejoin.equipmanage.common.entity;

import java.math.BigDecimal;
import java.util.Date;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 *
 *
 * @author zhouyi
 * @date 2020-09-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_equipment_point")
@ApiModel(value="EquipmentPoint对象", description="")
public class EquipmentPoint extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @Excel(name = "名称", orderNum = "2", width = 50)
    private String name;

    @Excel(name = "编号", orderNum = "1", width = 12)
    private String code;
    /**
     * 装备id
     */
    private Long equipmentId;

    @Excel(name = "装备名称", orderNum = "7", width = 50)
    private String equipmentName;

    private Date createDate;

    private String createBy;

    private String remark;

    @Excel(name = "数据类型", replace = {"模拟量_ANALOGUE", "开关量_SWITCH"}, orderNum = "3")
    private String type;

    private String value;

    private Long unit;

    @Excel(name = "单位", orderNum = "5", width = 12)
    private String unitName;

    private String equipmentClass;
    /**
     * 公司code
     */
    private String orgCode;
    /**
     * 告警类型
     */
    private Long alarmType;

    @TableField(exist = false)
    @Excel(name = "指标类型", replace = {"火灾告警_1", "电源开关_2", "换流变_6", "液位_3", "流量_4", "容量_5", "故障告警_7"}, orderNum = "4")
    private String alarmName;

    @Excel(name = "装备编号",  orderNum = "6", width = 12)
    private String equipmentCode;



}