package com.yeejoin.equipmanage.common.entity;

import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_stock_warning_rule")
@ApiModel(value="StockWarningRule对象", description="")
public class StockWarningRule extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "仓库ID")
    private Long warehouseId;

    @ApiModelProperty(value = "库存ID")
    private Long stockId;

    @ApiModelProperty(value = "预警数量")
    private BigDecimal amount;

    @ApiModelProperty(value = "修改时间")
    private Date dateUpdated;

    @ApiModelProperty(value = "修改人ID")
    private Long reviserId;

    @ApiModelProperty(value = "创建时间")
    private Date dateCreated;

    @ApiModelProperty(value = "创建人ID")
    private Long creatorId;

    @ApiModelProperty(value = "组织机构编码")
    private String orgCode;

    private Long equipmentId;

    private String companyName;

    private String departmentName;

    private String departmentOrgcode;


}
