package com.yeejoin.amos.supervision.common.enums;


public enum ExecuteStateNameEnum {

    通过("通过", 0),
    不通过("不通过", 1);

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private Integer code;

    ExecuteStateNameEnum(String name, Integer code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public static String getNameByCode(Integer code) {
        for (ExecuteStateNameEnum e : ExecuteStateNameEnum.values()) {
            if (code.equals(e.getCode())) {
                return e.getName();
            }
        }
        return null;
    }
}
