package com.yeejoin.equipmanage.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.BuildingAudit;
import com.yeejoin.equipmanage.common.vo.BuildingAuditVO;
import com.yeejoin.equipmanage.service.IBuildingAuditService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@RestController
@Api(tags = "消防建筑审核Api")
@RequestMapping(value = "/building-audit", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class BuildingAuditController extends AbstractBaseController {

	@Autowired
	IBuildingAuditService iBuildingAuditService;

	/**
	 * 保存数据
	 */
	@RequestMapping(value = "/saveAudit", method = RequestMethod.POST)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "保存审核信息", notes = "保存审核信息")
	public boolean saveAudit(@RequestBody BuildingAuditVO buildingAuditVO) {
		return iBuildingAuditService.saveAudit(buildingAuditVO);
	}

	/**
	 * 查询列表
	 */
	@RequestMapping(value = "/lists", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<BuildingAudit> listPage(Page page, BuildingAuditVO buildingAuditVO) {
		return iBuildingAuditService.auditList(page, buildingAuditVO);
	}

	/**
	 * 删除数据
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "删除")
	@DeleteMapping(value = "/deleteByIds")
	public int delete(@RequestBody List<Long> ids) {
		return iBuildingAuditService.deleteAudit(ids);
	}

	/**
	 * 根据id查询审核信息
	 */
	@RequestMapping(value = "/getAuditById", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "查询审核信息", notes = "查询审核信息")
	public BuildingAuditVO getAuditById(@RequestParam Long id) {
		return iBuildingAuditService.getAuditById(id);
	}

	/**
	 * 修改数据
	 */
	@RequestMapping(value = "/editAudit", method = RequestMethod.POST)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "修改审核资料", notes = "修改审核资料")
	public int editAudit(@RequestBody BuildingAuditVO buildingAuditVO) {
		return iBuildingAuditService.editAudit(buildingAuditVO);
	}

}
