package com.yeejoin.amos.boot.module.app.api.annotation;

import java.util.HashMap;
import java.util.Map;

public class ChargeMediaConverter implements Converter<String> {

    private static final Map<String, String> dictionary = new HashMap<>();

    static {
        dictionary.put("LIQUEFIED_NATURAL_GAS", "液化天然气");
        dictionary.put("LIQUEFIED_PETROLEUM_GAS", "液化石油气");
        dictionary.put("COMPRESSED_NATURAL_GAS", "压缩天然气");
        dictionary.put("HYDROGEN", "氢气");
        dictionary.put("HELIUM", "氦气");
        dictionary.put("AIR", "空气");
        dictionary.put("OXYGEN", "氧气");
        dictionary.put("PROPANE", "丙烷");
        dictionary.put("BUTANCE", "丁烷");
        dictionary.put("LIQUEFIED_CARBON_DIOXIDE", "液化二氧化碳");
        dictionary.put("LIQUID_OXYGEN", "液氧");
        dictionary.put("NITROGEN", "氮气");
        dictionary.put("ARGON", "氩气");
        dictionary.put("LIQUID_ARGON", "液氩");
        dictionary.put("LIQUID_NITROGEN", "液氮");
        dictionary.put("DISSOLVE_ACETYLENE", "溶解乙炔");
        dictionary.put("1,1,1,2-TETRAFLUOROETHANE_(R134A)", "1,1,1,2-四氟乙烷(R134a)");
    }

    @Override
    public String convertToLabelData(String key) {
        return dictionary.getOrDefault(key, key);
    }
}
