package com.yeejoin.amos.api.openapi.face.service;


import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.api.openapi.face.model.TmCylinderFillingModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.TmCylinderFillingMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.TmCylinderFilling;
import com.yeejoin.amos.api.openapi.service.MyBaseServiceImpl;
import com.yeejoin.amos.api.openapi.util.MultiFieldKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.utils.Bean;

import java.util.Date;
import java.util.List;


/**
 * 
 * <pre>
 * 气瓶充装信息--充装前检查 服务类
 * </pre>
 *
 * @author gwb
 * @version $Id: ElevatorService.java, v 0.1 2021年9月30日 下午3:28:55 gwb Exp $
 */
@Component
public class TmCylinderFillingService extends MyBaseServiceImpl<TmCylinderFillingModel, TmCylinderFilling, TmCylinderFillingMapper> {

	@Autowired
	private SyncCylinderDataService syncCylinderDataService;

    @DSTransactional
	public void createCylinderFillingBefore(List<TmCylinderFillingModel> model) {
		Date now = new Date();
		String appId = getAppId();
		for (TmCylinderFillingModel cylinderFillingModel : model) {
			cylinderFillingModel.setSequenceNbr(null);
			cylinderFillingModel.setRecDate(now);
			cylinderFillingModel.setAppId(appId);
		}
		List<TmCylinderFilling> tmCylinderFillingList = Bean.toModels(model, TmCylinderFilling.class);
		// 同步至气瓶业务库
		syncCylinderFillingBefore(model);

		this.saveOrUpdateBatchByUniqueFields(
				tmCylinderFillingList,
				tmCylinderFilling -> new LambdaQueryWrapper<TmCylinderFilling>()
						.eq(TmCylinderFilling::getAppId, tmCylinderFilling.getAppId())
						.eq(TmCylinderFilling::getSequenceCode, tmCylinderFilling.getSequenceCode())
						.eq(TmCylinderFilling::getFillingBeforeId, tmCylinderFilling.getFillingBeforeId()),
				entity -> new MultiFieldKey(entity.getAppId(), entity.getSequenceCode(), entity.getFillingBeforeId()),
				"appId", "sequenceCode", "fillingBeforeId");
	}

	private void syncCylinderFillingBefore(List<TmCylinderFillingModel> model) {
		syncCylinderDataService.syncCylinderFillingBefore(model);
	}
}
