package com.yeejoin.amos.boot.module.statistics.api.mapper;

import com.yeejoin.amos.boot.biz.common.dto.CountDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface JGStatisticsMapper {

    List<Map<String, Object>> maintenanceCountTopTen(@Param("dpFilterParamDto") DPFilterParamDto dpFilterParamDto, @Param("regionCodeList") List<Integer> regionCodeList);
    List<Map<String, Object>> maintenanceCount(@Param("dpFilterParamDto") DPFilterParamDto dpFilterParamDto, @Param("regionCodeList") List<Integer> regionCodeList);

    List<Map<String, Object>> installEquCount(@Param("cityCode") String cityCode, @Param("startTime") String startTime);

    List<Map<String, Object>> maintenanceEquCount(@Param("cityCode") String cityCode, @Param("startTime") String startTime);

    List<Map<String, Object>> reformEquCount(@Param("cityCode") String cityCode, @Param("startTime") String startTime);

    List<Map<String, Object>> transferEquCount(@Param("cityCode") String cityCode, @Param("startTime") String startTime);



    List<Map<String, Object>> useEquCount(@Param("cityCode") String cityCode, @Param("startTime") String startTime);

    List<Map<String, Object>> changeReformEquCount(@Param("cityCode") String cityCode, @Param("startTime") String startTime);

    List<Map<String, Object>> changeTransferEquCount(@Param("cityCode") String cityCode, @Param("startTime") String startTime);

    List<Map<String, Object>> changeUnitEquCount(@Param("cityCode") String cityCode, @Param("startTime") String startTime);

    List<Map<String, Object>> vehicleEquCount(@Param("cityCode") String cityCode, @Param("startTime") String startTime);

    List<Map<String, Object>> newRegEquCountByMonth(@Param("cityCode") String cityCode);

    List<Map<String, Object>> newVehicleEquCountByMonth(@Param("cityCode") String cityCode);

    List<Map<String, Object>> newRegEquCountByYear(@Param("cityCode") String cityCode);

    List<Map<String, Object>> newVehicleEquCountByYear(@Param("cityCode") String cityCode);

    String newVehicleCountByYear(@Param("cityCode") String cityCode);

    String newVehicleCountByMonth(@Param("cityCode") String cityCode);

    long certificateCountByOrgCode(@Param("orgCode") String orgCode);

    long useCountByOrgCode(@Param("orgCode") String orgCode);

    Long over15yearsCount(@Param("orgCode") String orgCode, @Param("time") String time);

    Long constructionNoticeCount(@Param("orgCode") String orgCode);

    Long changeCountByOrgCode(@Param("orgCode") String orgCode);

    List<Map<String, Object>> selectNoticeList(@Param("orgCode") String orgCode, @Param("time") String time);

    List<Map<String, Object>> selectNoticeCountTopTen(@Param("orgCode") String orgCode, @Param("time") String time);

    List<CountDto> queryNoticeAvgDayByReceiveCompany(@Param("dto") DPFilterParamDto dpFilterParamDto,@Param("orgCode") String orgCode);

    List<CountDto> queryUseAvgDayByReceiveCompany(@Param("dto") DPFilterParamDto dpFilterParamDto, @Param("orgCode") String orgCode);

    List<CountDto> queryChangeAvgDayByReceiveCompany(@Param("dto") DPFilterParamDto dpFilterParamDto, @Param("orgCode")  String orgCode);

    List<CountDto> queryDisableAvgDayByReceiveCompany(@Param("dto") DPFilterParamDto dpFilterParamDto, @Param("orgCode")  String orgCode);

    List<CountDto> queryCancelAvgDayByReceiveCompany(@Param("dto") DPFilterParamDto dpFilterParamDto, @Param("orgCode")  String orgCode);
}
