package com.yeejoin.amos.boot.module.ymt.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.dto.CountDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.EquEnterDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzBaseEnterpriseInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzBaseEnterpriseInfo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 企业数据信息 Mapper 接口
 *
 * @author duanwei
 * @date 2022-08-10
 */
@Mapper
public interface TzBaseEnterpriseInfoMapper extends BaseMapper<TzBaseEnterpriseInfo> {

    /**
     * 查找企业关联设备详情列表
     *
     * @param sequenceNbr 企业id
     * @return EquEnterDto 使用登记证代码、设备名称、设备类别、设备位置
     */
    List<EquEnterDto> getInfo(String sequenceNbr);

    /**
     * 根据企业名称查找设备
     *
     * @param useUnit 企业名称
     * @return
     */
    List<EquEnterDto> getInfoByUseUnit(String useUnit);

    /**
     * 根据企业名称查找企业详情信息
     *
     * @param useUnit
     * @return
     */
    TzBaseEnterpriseInfo selectByUseUnit(String useUnit);


    IPage<TzBaseEnterpriseInfoDto> page(Page<TzBaseEnterpriseInfoDto> page, TzBaseEnterpriseInfoDto tzBaseEnterpriseInfoDto);

    IPage<TzBaseEnterpriseInfoDto> pageList(Page<TzBaseEnterpriseInfoDto> page, TzBaseEnterpriseInfoDto tzBaseEnterpriseInfoDto, List orgCodeList);


    /**
     * 查找企业关联设备详情列表
     */
    List<TzBaseEnterpriseInfoDto> getInspectionUnitList(String openBizType);

    List<TzBaseEnterpriseInfoDto> getInspectionUnitListByCode(@Param("list") List<String> codes, @Param("city") String city, @Param("openBizType") String openBizType);

    /**
     * 根据ID查找企业详情信息
     *
     * @param sequenceNbr sequenceNbr
     * @return {@link  TzBaseEnterpriseInfo}
     * @throws
     * @author yangyang
     */
    TzBaseEnterpriseInfo selectBySeq(Long sequenceNbr);

    List<CountDto> countByUnitTypeAndOrgCode(@Param("orgCode") String orgCode);

    List<CountDto> countByUnitTypeAndOrgCodeNoParam();

    /**
     * 按照状态统计
     *
     * @param orgCode         公司的orgCode
     * @param operatingStatus 营业状态
     * @param cityCode        区域code
     * @return Long   统计数量
     */
    Long countByOperatingStatusAndOrgCode(@Param("orgCode") String orgCode, @Param("operatingStatus") String operatingStatus, @Param("cityCode") String cityCode);


    List<TzBaseEnterpriseInfoDto> queryByUseCode(@Param("useCodes") List<String> useCode);
}
