package com.yeejoin.amos.boot.module.jg.api.enums;

import com.yeejoin.amos.boot.module.common.api.enums.JgBusinessTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.*;

@Getter
@AllArgsConstructor
public enum CylinderFillingMediumEnum {
    COMPRESSED_NATURAL_GAS("压缩天然气", "COMPRESSED_NATURAL_GAS"),
    LIQUEFIED_NATURAL_GAS("液化天然气", "LIQUEFIED_NATURAL_GAS"),
    LIQUEFIED_PETROLEUM_GAS("液化石油气", "LIQUEFIED_PETROLEUM_GAS"),
    HYDROGEN("氢气", "HYDROGEN");

    private final String name;
    private final String code;

    public static String of(String code) {
        for (CylinderFillingMediumEnum constants : values()) {
            if (constants.getCode().equals(code)) {
                return constants.getName();
            }
        }
        return null;
    }

    public static List<Map<String,Object>> getEnumList() {
        List<Map<String, Object>> list = new ArrayList<>();
        for (CylinderFillingMediumEnum testEnum : EnumSet.allOf(CylinderFillingMediumEnum.class)) {
            HashMap<String, Object> map = new HashMap<>();
            map.put("title",testEnum.getName());
            map.put("value",testEnum.getCode());
            list.add(map);
        }
        return list;
    }
}
