package com.yeejoin.amos.boot.module.common.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.utils.Menu;
import com.yeejoin.amos.boot.module.common.api.dto.LinkageUnitDto;
import com.yeejoin.amos.boot.module.common.api.dto.LinkageUnitZhDto;
import com.yeejoin.amos.boot.module.common.api.dto.RequestData;

import java.util.List;

/**
 * 联动单位接口类
 *
 * @author system_generator
 * @date 2021-07-16
 */
public interface ILinkageUnitService {

	List<LinkageUnitZhDto> listLinkageUnitZhDto(Integer pageNum, Integer pageSize, RequestData par);

	Integer listLinkageUnitZhDtoCount(RequestData par);

	LinkageUnitDto queryOne(Long sequenceNbr);

	/**
	 * 联动单位分页查询
	 *
	 * @param page
	 * @param isDelete
	 * @param unitName                 单位名称
	 * @param linkageUnitType          联动单位类型
	 * @param emergencyLinkageUnitCode 紧急联动单位类型code
	 * @return
	 */
	Page<LinkageUnitDto> queryForLinkageUnitPage(IPage<LinkageUnitDto> page, Boolean isDelete, String unitName,
			String linkageUnitTypeCode, String linkageUnitType, String emergencyLinkageUnitCode, String inAgreement, String bizOrgCode);

	/**
	 * 获取当前存在的联动单位的类型组code
	 * 
	 * @return
	 */
	public List<Menu> getEmergencyLinkageUnitCodeGroupBy(String type, String rootName, String bizOrgCode);

	List<LinkageUnitDto> exportToExcel(String unitName,String linkageUnitTypeCode,String emergencyLinkageUnitCode, String bizOrgCode);

	List<LinkageUnitDto> queryForLinkageUnitList(Boolean isDelete);
}
