package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_upload_file")
@ApiModel(value = "UploadFile对象", description = "")
public class UploadFile extends BaseEntity {

	private static final long serialVersionUID = 1L;

	private String url;

	private String name;

	private Long size;

	@ApiModelProperty(value = "文件类型，详情见文件枚举")
	private String fileType;

	@ApiModelProperty(value = "equipment或者car")
	private String objectType;

	@ApiModelProperty(value = "装备或车辆id")
	private Long objectId;

	@ApiModelProperty(value = "用户ID")
	@TableField(value = "user_id", fill = FieldFill.INSERT)
	private Long userId;

	@ApiModelProperty(value = "公司名称")
	@TableField(value = "company_name", fill = FieldFill.INSERT)
	private String companyName;

	@ApiModelProperty(value = "公司code")
	@TableField(value = "org_code", fill = FieldFill.INSERT)
	private String orgCode;

	@ApiModelProperty(value = "部门名称")
	@TableField(value = "department_name", fill = FieldFill.INSERT)
	private String departmentName;

	@ApiModelProperty(value = "部门code")
	@TableField(value = "department_orgcode", fill = FieldFill.INSERT)
	private String departmentOrgcode;

}
