package com.yeejoin.precontrol.common.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.precontrol.common.entity.UserEvaluationLog;

import java.util.List;

/**
 * 用户评价记录表 服务类
 *
 * @author tb
 * @date 2021-01-28
 */
public interface IUserEvaluationLogService extends IService<UserEvaluationLog> {

    /**
     * 根据被评价人id获取列表记录
     *
     * @param personId 被评价人id
     * @return
     */
    IPage<UserEvaluationLog> listByPersonId(String pageNum, String pageSize, String personId);

    /**
     * 根据任务id查询评价记录
     *
     * @param taskId
     * @return
     */
    List<UserEvaluationLog> listByTaskId(String taskId);
}
