package com.yeejoin.equipmanage.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.equipmanage.common.datasync.entity.FireEquipmentFireAlarm;
import com.yeejoin.equipmanage.common.datasync.vo.AppAlarmExtVo;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarm;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarmLog;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author keyong
 * @title: EquipmentSpecificAlarmMapper
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2020/10/30 18:15
 */
@Mapper
public interface EquipmentSpecificAlarmLogMapper extends BaseMapper<EquipmentSpecificAlarmLog> {


    void updateAlarmLogByIotCodeAndIndexKey(@Param("dto") EquipmentSpecificAlarm dto);

    List<AppAlarmExtVo> findByIdList(@Param("list") List<Long> idList);

    List<AppAlarmExtVo> findByIdListNoBuildId(@Param("list") List<Long> idBNullList);

    List<EquipmentSpecificAlarmLog> getIsConfirmByAlarmId(@Param("equipmentSpecificId") Long equipmentSpecificId
											    		, @Param("equipmentSpecificIndexKey") String equipmentSpecificIndexKey
											    		, @Param("isConfirm") String isConfirm);
    
    List<FireEquipmentFireAlarm> getFireEquipAlarmLogDetailsById(@Param("list") List<Long> ids);

    Map<String, Object> getPlanRecord();

    List<Map<String, Object>> getOtherEquipInfo(@Param("date") String date, @Param("equipmentId") Long equipmentId);

    Map<String, Object> alarmEquipLink(String date, String pattern, String cleanFlag);

    Map<String, Object> unCleanAlarmEquipLink(String date, String pattern, String cleanFlag);
}
