package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 发货单枚举
 *
 * @author Provence
 * @version v1.0
 * @date 2023/8/18 16:49
 */
public class PreparationMoneyEnum {

    /**
     * 订单状态
     *
     */
    @Getter
    @AllArgsConstructor
    public enum DOCUMENT_STATE {
        未完成("未完成", "0", "未完成"),// 订单状态0未完成1已完成2作废
        已完成("已完成", "1", "0"),//发货状态 0 未发货1已发货
        作废("已作废", "2", "1");//到货状态0未到货1已到货
        /**
         * 名称，描述
         */
        private String name;
        /**
         * 编码
         */
        private String code;

        /**
         * 编码
         */
        private String describe;

        public static String getName(String code) {
            for(DOCUMENT_STATE type: DOCUMENT_STATE.values()) {
                if (type.getCode().equals(code)) {
                    return type.getName();
                }
            }
            return null;
        }
    }

    /**
     * 发货状态
     *
     */
    @Getter
    @AllArgsConstructor
    public enum SHIPMENT_STATUS {
        未发货("未发货", "0", "未发货"),// 订单状态0未完成1已完成2作废
        已发货("已发货", "1", "已发货");//发货状态 0 未发货1已发货
        /**
         * 名称，描述
         */
        private String name;
        /**
         * 编码
         */
        private String code;

        /**
         * 编码
         */
        private String describe;

        public static String getName(String code) {
            for(SHIPMENT_STATUS type: SHIPMENT_STATUS.values()) {
                if (type.getCode().equals(code)) {
                    return type.getName();
                }
            }
            return null;
        }
    }
    /**
     * 到货状态
     *
     */
    @Getter
    @AllArgsConstructor
    public enum RECEIVING_STATUS {
        未到货("未到货", "0", "未到货"),// 订单状态0未完成1已完成2作废
        已到货("已到货", "1", "已到货");//发货状态 0 未发货1已发货
        /**
         * 名称，描述
         */
        private String name;
        /**
         * 编码
         */
        private String code;

        /**
         * 编码
         */
        private String describe;

        public static String getName(String code) {
            for(RECEIVING_STATUS type: RECEIVING_STATUS.values()) {
                if (type.getCode().equals(code)) {
                    return type.getName();
                }
            }
            return null;
        }
    }
    /**
     * 业主类型
     *
     */
    @Getter
    @AllArgsConstructor
    enum OWNER_TYPE {
        非居民("非居民", "0", "非居民"),
        居民("居民", "1", "居民");//到货状态0未到货1已到货
        /**
         * 名称，描述
         */
        private String name;
        /**
         * 编码
         */
        private String code;

        /**
         * 编码
         */
        private String describe;
    }

}
