package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.yeejoin.amos.boot.module.hygf.api.dto.SurveyInfoAllDto;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.SurveyInformationServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.SurveyInformationDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 勘察信息
 *
 * @author system_generator
 * @date 2023-07-07
 */
@RestController
@Api(tags = "勘察信息Api")
@RequestMapping(value = "/survey-information")
public class SurveyInformationController extends BaseController {

    @Autowired
    SurveyInformationServiceImpl surveyInformationServiceImpl;

    /**
     * 新增勘察信息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增勘察信息", notes = "新增勘察信息")
	public ResponseModel<SurveyInformationDto> save(@RequestBody SurveyInformationDto model) {
	    model = surveyInformationServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新勘察信息", notes = "根据sequenceNbr更新勘察信息")
	public ResponseModel<SurveyInformationDto> updateBySequenceNbrSurveyInformation(@RequestBody SurveyInformationDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(surveyInformationServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除勘察信息", notes = "根据sequenceNbr删除勘察信息")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(surveyInformationServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个勘察信息",  notes = "根据sequenceNbr查询单个勘察信息")
	public ResponseModel<SurveyInformationDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(surveyInformationServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "勘察信息分页查询",  notes = "勘察信息分页查询")
	public ResponseModel<Page<SurveyInformationDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<SurveyInformationDto> page = new Page<SurveyInformationDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(surveyInformationServiceImpl.queryForSurveyInformationPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "勘察信息列表全部数据查询",   notes = "勘察信息列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<SurveyInformationDto>> selectForList() {
	    return ResponseHelper.buildResponse(surveyInformationServiceImpl.queryForSurveyInformationList());
	}

	/**
	 * 勘察信息数据提交
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST",value = "勘察信息数据提交",   notes = "勘察信息数据提交")
	@PostMapping(value = "/surveySubmit")
	public ResponseModel<SurveyInfoAllDto> surveySubmit(@RequestBody SurveyInfoAllDto surveyInfoAllDto,
																									@RequestParam(value = "operationType") String operationType) {
		SurveyInfoAllDto returnDto = surveyInformationServiceImpl.saveSurveyInfo(surveyInfoAllDto,operationType);
		return ResponseHelper.buildResponse(returnDto);
	}

	/**
	 * 勘察信息编辑
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "勘察信息编辑",   notes = "勘察信息编辑")
	@GetMapping(value = "/surveyQuery")
	public ResponseModel<SurveyInfoAllDto> surveyQuery(@RequestParam(value = "surveyInformationId",required = false ) String surveyInformationId,
													   												 @RequestParam(value = "peasantHouseholdId",required = false ) String peasantHouseholdId,
													   												@RequestParam(value = "processInstanceId",required = false)String processInstanceId) {
		AgencyUserModel userInfo = getUserInfo();
		SurveyInfoAllDto returnDto = surveyInformationServiceImpl.querySurveyInfo(surveyInformationId,peasantHouseholdId,processInstanceId,userInfo);
		return ResponseHelper.buildResponse(returnDto);
	}
}
