package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.IdxBizFanHealthIndexDto;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanPointTag;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanWarningRecord;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizPvPointTag;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizPvWarningRecord;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizFanPointTagMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizPvPointTagMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.IdxBizFanHealthIndexServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import java.util.*;

/**
 * 
 *
 * @author system_generator
 * @date 2023-08-15
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/idx-biz-fan-health-index")
public class IdxBizFanHealthIndexController extends BaseController {

    @Autowired
    IdxBizFanHealthIndexServiceImpl idxBizFanHealthIndexServiceImpl;

    @Autowired
    IdxBizFanPointTagMapper idxBizFanPointTagMapper;
    @Autowired
    IdxBizPvPointTagMapper idxBizPvPointTagMapper;
    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<IdxBizFanHealthIndexDto> save(@RequestBody IdxBizFanHealthIndexDto model) {
	    model = idxBizFanHealthIndexServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<IdxBizFanHealthIndexDto> updateBySequenceNbrIdxBizFanHealthIndex(@RequestBody IdxBizFanHealthIndexDto model,@PathVariable(value = "sequenceNbr") String sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(idxBizFanHealthIndexServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(idxBizFanHealthIndexServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<IdxBizFanHealthIndexDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(idxBizFanHealthIndexServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<IdxBizFanHealthIndexDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<IdxBizFanHealthIndexDto> page = new Page<IdxBizFanHealthIndexDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(idxBizFanHealthIndexServiceImpl.queryForIdxBizFanHealthIndexPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<IdxBizFanHealthIndexDto>> selectForList() {
	    return ResponseHelper.buildResponse(idxBizFanHealthIndexServiceImpl.queryForIdxBizFanHealthIndexList());
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "预警监测风机层左侧列表",   notes = "预警监测风机层左侧列表")
	@GetMapping(value = "/tableLeftList")
	public ResponseModel<Page<Map<String,Object>>> queryForLeftTableList(@RequestParam(required = false) String STATION, @RequestParam(required = false)String HEALTHLEVEL,@RequestParam(required = false) String EQUIPMENTNAME,Integer current,Integer size) {
		Page<Map<String,Object>> page = new Page<Map<String,Object>>();
		page.setCurrent(current);
		page.setSize(size);
		int total = idxBizFanHealthIndexServiceImpl.queryForLeftTableListCount(STATION, HEALTHLEVEL, EQUIPMENTNAME);
		page.setTotal(Long.valueOf(total));
		page.setRecords(idxBizFanHealthIndexServiceImpl.queryForLeftTableList(STATION,HEALTHLEVEL,EQUIPMENTNAME,(current-1)*size,size));
		return ResponseHelper.buildResponse(page);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "预警监测风机层仪表盘",   notes = "预警监测风机层仪表盘")
	@GetMapping(value = "/queryForLeftTableListNum")
	public ResponseModel<Map<String,Object>> queryForLeftTableListNum(@RequestParam(required = false)String STATION, @RequestParam(required = false)String HEALTHLEVEL,@RequestParam(required = false)String EQUIPMENTNAME) {
		return ResponseHelper.buildResponse(	idxBizFanHealthIndexServiceImpl.queryForLeftTableListNum(STATION, HEALTHLEVEL, EQUIPMENTNAME));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "预警监测测点层左侧列表",   notes = "预警监测风机层左侧列表")
	@GetMapping(value = "/tableLeftByPointList")
	public ResponseModel<Page<Map<String,Object>>> queryForLeftTableByPointList(@RequestParam(required = false) String STATION, @RequestParam(required = false)String HEALTHLEVEL,@RequestParam(required = false) String EQUIPMENTNAME,@RequestParam(required = false)String POINTNAME,Integer current,Integer size) {
		Page<Map<String,Object>> page = new Page<Map<String,Object>>();
		page.setCurrent(current);
		page.setSize(size);
		int total = idxBizFanHealthIndexServiceImpl.queryForLeftTableListByPointCount(STATION, HEALTHLEVEL, EQUIPMENTNAME,POINTNAME);
		page.setTotal(Long.valueOf(total));
		page.setRecords(idxBizFanHealthIndexServiceImpl.queryForLeftTableListByPoint(STATION,HEALTHLEVEL,EQUIPMENTNAME,POINTNAME,(current-1)*size,size));
		return ResponseHelper.buildResponse(page);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "预警监测测点层仪表盘",   notes = "预警监测风机层仪表盘")
	@GetMapping(value = "/queryForLeftTableListByPointNum")
	public ResponseModel<Map<String,Object>> queryForLeftTableListByPointNum(@RequestParam(required = false)String STATION, @RequestParam(required = false)String HEALTHLEVEL,@RequestParam(required = false)String EQUIPMENTNAME,@RequestParam(required = false)String POINTNAME) {
		return ResponseHelper.buildResponse(	idxBizFanHealthIndexServiceImpl.queryForLeftTableListByPointNum(STATION, HEALTHLEVEL, EQUIPMENTNAME,POINTNAME));
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "预警监测设备级统计",   notes = "预警监测设备级统计")
	@GetMapping(value = "/queryForPointNum")
	public ResponseModel<List<Map<String,Object>>> queryForLeftTableListByPointNum(@RequestParam(required = false) String STATION,@RequestParam(required = false) String SUBARRAY,@RequestParam(required = false) String  EQUIPMENTNAME) {
		List<IdxBizFanWarningRecord> idxBizPvWarningRecordList = idxBizFanHealthIndexServiceImpl.warningData(STATION, SUBARRAY, EQUIPMENTNAME);
		int total = idxBizFanHealthIndexServiceImpl.pointNum(STATION, SUBARRAY, EQUIPMENTNAME);

		Map<String,Object> map =new HashMap<>();
		Map<String,Object> map1 =new HashMap<>();
		Map<String,Object> warningNum =new HashMap<>();
		Map<String,Object> pointNum =new  HashMap<>();

		map1.put("name","危险");
		map1.put("value",idxBizPvWarningRecordList.stream().filter(e->e.getWarningName().equals("危险")).count());
		map.put("name","警告");
		map.put("value",idxBizPvWarningRecordList.stream().filter(e->e.getWarningName().equals("警告")).count());
		warningNum.put("name","注意");
		warningNum.put("value",idxBizPvWarningRecordList.stream().filter(e->e.getWarningName().equals("注意")).count());
		pointNum.put("name","正常");
		pointNum.put("value",total  - idxBizPvWarningRecordList.size());

		List<Map<String,Object>> list = new ArrayList<>();
		list.add(pointNum);
		list.add(warningNum);
		list.add(map);
		list.add(map1);

		return ResponseHelper.buildResponse(list);
	}

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(httpMethod = "GET",value = "测点运行趋势图",   notes = "测点运行趋势图")
    @GetMapping(value = "/getqyt")
    public ResponseModel<Object> getqyt(
            String type,
            String address,
            String statioName,
            String equipmentName,
            String  arae,
            @RequestParam(value = "startTime", required = false) String startTime,
            @RequestParam(value = "endTime", required = false) String endTime
    ) {
       if(address.isEmpty()||statioName.isEmpty()||equipmentName.isEmpty()||arae.isEmpty()){
           throw new RuntimeException("片区，场站，设备名称，子系统，分析变量不能为空");
       }

        return ResponseHelper.buildResponse(idxBizFanHealthIndexServiceImpl.getqyt( type,address,statioName,equipmentName,arae,startTime,endTime));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(httpMethod = "GET",value = "工况字典详情",   notes = "工况字典详情")
    @GetMapping(value = "/getZDXQ")
    public ResponseModel<Object> getZDXQ(
            String type,
            String  id
    ) {
        Object object=null;
	    if(type.equals("1")){
            object= idxBizPvPointTagMapper.selectById(id);
        }else{
            object= idxBizFanPointTagMapper.selectById(id);
        }
        return ResponseHelper.buildResponse(object);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(httpMethod = "GET",value = "工况字典修改",   notes = "工况字典修改")
    @PostMapping (value = "/updateZDXQ")
    public ResponseModel<Object> updateZDXQ(
            String type,
            String  id,
            String pointDirection,
            String  tagCode
    ) {
        idxBizFanHealthIndexServiceImpl.updatezd( type,id, pointDirection,tagCode);
        return ResponseHelper.buildResponse(null);
    }

	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "预警监测测点层左侧列表",   notes = "预警监测风机层左侧列表")
	@GetMapping(value = "/selectPointByANALYSISTYPE")
	public ResponseModel<Map<String,Object>> selectPointByANALYSISTYPE(@RequestParam(required = false) String STATION, @RequestParam(required = false)String HEALTHLEVEL,@RequestParam(required = false) String EQUIPMENTNAME,@RequestParam(required = false)String POINTNAME,@RequestParam(required = false)String startTime,@RequestParam(required = false) String endTime) {

		List<Map<String, Object>> maps = idxBizFanHealthIndexServiceImpl.selectPointByANALYSISTYPE(STATION, HEALTHLEVEL, EQUIPMENTNAME, POINTNAME,startTime,endTime);
		Map<String,Object> result = new HashMap<>();
		List<Object> seriesData = new ArrayList<>();
		List<Object> axisData = new ArrayList<>();

		Collections.reverse(seriesData);
		Collections.reverse(axisData);

		for (Map<String, Object> map : maps) {
			seriesData.add(map.get("value"));
			axisData.add(map.get("REC_DATE"));
		}

		result.put("seriesData",seriesData);
		result.put("axisData",axisData);
		return ResponseHelper.buildResponse(result);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "查询场站下设备状态统计",   notes = "查询场站下设备状态统计")
	@GetMapping (value = "/getFanEquipStatusByStation")
	public ResponseModel<List<Map<String,Object>>> getFanEquipStatusByStation(String STATION) {
		Map<String, Object> map = idxBizFanHealthIndexServiceImpl.getFanEquipStatusByStation(STATION);
		List<Map<String,Object>>  maps = new ArrayList<>();


		Map<String,Object> anquan = new HashMap<>();
		anquan.put("name","安全");
		anquan.put("value",map.get("安全"));
		maps.add(anquan);
		Map<String,Object> zhuyi = new HashMap<>();
		zhuyi.put("name","注意");
		zhuyi.put("value",map.get("注意"));
		maps.add(zhuyi);
		Map<String,Object> jinggao = new HashMap<>();
		jinggao.put("name","警告");
		jinggao.put("value",map.get("警告"));
		maps.add(jinggao);
		Map<String,Object> weixian = new HashMap<>();
		weixian.put("name","危险");
		weixian.put("value",map.get("危险"));
		maps.add(weixian);


		return ResponseHelper.buildResponse(maps);
	}


}
