package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.jxiop.biz.ESDto.ESEquipments;
import com.yeejoin.amos.boot.module.jxiop.biz.Enum.SmartAnalyseEnum;
import com.yeejoin.amos.boot.module.jxiop.biz.Thread.MyServiceThread;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.IdxBizFanPointProcessVariableClassificationDto;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.IdxBizPvPointProcessVariableClassificationDto;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.*;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.*;
import com.yeejoin.amos.boot.module.jxiop.biz.tdmapper.IndicatorDataMapper;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.joda.time.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.utils.DateTimeUtil;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.*;
import java.util.stream.Collectors;

@Service("commonServiceImpl")
@Configuration
public class CommonServiceImpl {
    private static final HashMap<String, Object> cacheExecInfo = new HashMap<>();
    //utc时间格式
    public static final String FORMAT_UTC = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String FORMAT_DEFAULT = "yyyy-MM-dd HH:mm:ss";
    private static final Logger logger = LoggerFactory.getLogger(CommonServiceImpl.class);
    //-----------------调用算法时间间隔----------------
    @Value("${sleep.time:10}")
    Integer sleepTime;
    @Value("${sleep.time:30}")
    Integer zxzsleepTime;
    @Value("${base.url:http://139.9.173.44:30009/maas/maas/processes/api/}")
    String baseUrl;

    String baseUrlXGX = "http://139.9.173.44:8052/intelligent-analysis/correlation";

    //指数分析URL
    @Value("${base.url.zsfx:http://139.9.173.44:8052/intelligent-analysis/index-analysis}")
    String baseUrlZSFX;

    //----------------工况变量工况变量划分请求属性配置------------------------
    @Value("${gkblhffan.url:74435221-796d-43c0-ae72-319792b8f89e}")
    String gkqjhfurlfan;
    @Value("${gkblhfpv.url:728d13ae-f333-4e36-b55c-6a0b6bb3b150}")
    String gkqjhfurlpv;
    @Value("${gkblhf.key:input 1}")
    String gkqjhfkey;
    //----------------工况变量相关性计算请求属性配置------------------------
    @Value("${gkxgxfxfan.url:7e40b660-67d5-4678-886d-da125a3c4587}")
    String gkxgxfxurlfan;
    @Value("${gkxgxfxpv.url:3d583330-1b3c-4c7a-b904-9e94f3de9fc9}")
    String gkxgxfxurlpv;
    @Value("${gkxgxfx.key:input 1}")
    String gkxgxfxkey;
    //----------------工况变量中心值计算相关请求属性配置------------------------
    @Value("${gkzxzjsfan.url:a6f8d689-0028-445e-b797-493b5ac65e42}")
    String gkzxzjsurlfan;
    @Value("${gkzxzjspv.url:0945f8f6-faa6-4bd6-87fd-c7bed37d9bdc}")
    String gkzxzjsurlpv;
    @Value("${gkzxzjs.key:input 1}")
    String gkzxzjskey1;

    @Value("${gkzxzjs.key:input 2}")
    String gkzxzjskey2;

    //----------------健康指数值计算相关请求属性配置------------------------
    @Value("${jkzsjs.url:aec8ad20-6d63-4f62-99f6-2d71756cacb6}")
    String jkzsjsfjurl;

    @Value("${jkzsjs.url:a9a404d4-6ead-440e-9fcb-b95d5a239b10}")
    String jkzsgfurl;
    @Value("${openHealth:true}")
    Boolean openHealth;
    //    {"tableName": "idx_biz_fan_point_process_variable_classification"} 风机工况变量划分
    //    {"tableName": "idx_biz_pv_point_process_variable_classification"}  光伏工况变量画分
    //    {"tableName": "idx_biz_fan_point_var_correlation"} 风机相关性
    //    {"tableName": "idx_biz_pv_point_var_correlation"} 光伏相关性
    @Autowired
    private IdxBizFanPointProcessVariableClassificationMapper idxBizFanPointProcessVariableClassificationMapper;
    @Autowired
    private IdxBizPvPointProcessVariableClassificationMapper idxBizPvPointProcessVariableClassificationMapper;
    @Autowired
    private IdxBizFanPointVarCorrelationMapper idxBizFanPointVarCorrelationMapper;
    @Autowired
    private IdxBizPvPointVarCorrelationMapper idxBizPvPointVarCorrelationMapper;

    @Autowired
    private IndicatorDataMapper indicatorDataMapper;
    @Autowired
    IdxBizFanHealthIndexServiceImpl idxBizFanHealthIndexService;

    @Autowired
    IdxBizPvHealthIndexServiceImpl idxBizPvHealthIndexService;
    @Autowired
    IdxBizFanHealthLevelMapper idxBizFanHealthLevelMapper;
    @Autowired
    IdxBizPvHealthLevelMapper idxBizPvHealthLevelMapper;

    @Autowired
    private ElasticsearchRestTemplate elasticsearchTemplate;

    @Autowired
    IdxBizFanPointVarCentralValueMapper idxBizFanPointVarCentralValueMapper;

    @Autowired
    IdxBizPvPointVarCentralValueMapper idxBizPvPointVarCentralValueMapper;

    @Autowired
    HealthStatusIndicatorServiceImpl healthStatusIndicatorService;

    /**
     * @return
     * @deprecated 获取工况变量列表风机
     */
    public HashMap<String, List<IdxBizFanPointProcessVariableClassification>> getIdxBizFanPointProcessVariableClassificationList() {

        HashMap<String, List<IdxBizFanPointProcessVariableClassification>> idxBizFanPointProcessVariableClassification = new HashMap<>();
        List<String> gateWayIdList = idxBizFanPointProcessVariableClassificationMapper.gateWayIdListFan();
        List<IdxBizFanPointProcessVariableClassification> IdxBizFanPointProcessVariableClassificationList = idxBizFanPointProcessVariableClassificationMapper.selectList(new QueryWrapper<IdxBizFanPointProcessVariableClassification>().isNotNull("SEQUENCE_NBR").eq("TAG_CODE", "工况变量"));
        List<IdxBizFanPointProcessVariableClassification> finalIdxBizFanPointProcessVariableClassificationList = IdxBizFanPointProcessVariableClassificationList;
        gateWayIdList.forEach(s -> {
            idxBizFanPointProcessVariableClassification.put( s, finalIdxBizFanPointProcessVariableClassificationList.stream().filter(idxBizFanPointProcessVariableClassification1 -> idxBizFanPointProcessVariableClassification1.getGatewayId().toString().equals(s)).collect(Collectors.toList()));
        });
        return idxBizFanPointProcessVariableClassification;
    }

    /**
     * @return
     * @deprecated 获取工况变量列表光伏
     */
    public HashMap<String, List<IdxBizPvPointProcessVariableClassification>> getIdxBizPvPointProcessVariableClassificationList() {

        HashMap<String, List<IdxBizPvPointProcessVariableClassification>> idxBizPvPointProcessVariableClassificationHashMap = new HashMap<>();
        List<String> gateWayIdList = idxBizPvPointProcessVariableClassificationMapper.gateWayIdListPv();
        List<IdxBizPvPointProcessVariableClassification> idxBizPvPointProcessVariableClassificationList = idxBizPvPointProcessVariableClassificationMapper.selectList(new QueryWrapper<IdxBizPvPointProcessVariableClassification>().isNotNull("SEQUENCE_NBR").eq("TAG_CODE", "工况变量"));
        List<IdxBizPvPointProcessVariableClassification> finalIdxBizPvPointProcessVariableClassificationList = idxBizPvPointProcessVariableClassificationList;
        gateWayIdList.forEach(s -> {
            idxBizPvPointProcessVariableClassificationHashMap.put(s, finalIdxBizPvPointProcessVariableClassificationList.stream().filter(idxBizFanPointProcessVariableClassification -> idxBizFanPointProcessVariableClassification.getGatewayId().toString().equals(s)).collect(Collectors.toList()));
        });
        return idxBizPvPointProcessVariableClassificationHashMap;
    }

    public String getFanConditionVariablesByTimeThread(String startTime, String endTime) {
        String result = "开始计算";
        if (!ObjectUtils.isEmpty(cacheExecInfo.get(SmartAnalyseEnum.FAN_QJHF.getKey()))) {
            result = "正在计算中";
        } else {
            MyServiceThread myServiceThread = new MyServiceThread(this, startTime, endTime, SmartAnalyseEnum.FAN_QJHF.getKey());
            myServiceThread.start();
            cacheExecInfo.put(SmartAnalyseEnum.FAN_QJHF.getKey(), myServiceThread);
        }
        return result;
    }

    //遍历工况列表数据-风机
    public void getFanConditionVariablesByTime(String startTime, String endTime) {
        try {
//            String startTimeUTC = getUtcTimeString(startTime);
//            String endTimeUTC = getUtcTimeString(endTime);
            HashMap<String, List<IdxBizFanPointProcessVariableClassification>> idxBizFanPointProcessVariableClassificationHashMap = getIdxBizFanPointProcessVariableClassificationList();
            idxBizFanPointProcessVariableClassificationHashMap.keySet().forEach(s -> {
                List<IdxBizFanPointProcessVariableClassification> list = idxBizFanPointProcessVariableClassificationHashMap.get(s);
                if (list.size() > 0) {
                    foreachHandlerConditionVariabFan(s, list, startTime, endTime);
                }
            });
            cacheExecInfo.remove(SmartAnalyseEnum.FAN_QJHF.getKey());
        } catch (Exception exception) {
            cacheExecInfo.remove(SmartAnalyseEnum.FAN_QJHF.getKey());
        }
    }


    public String getPvConditionVariablesByTimeThread(String startTime, String endTime) {
        String result = "开始计算";
        if (!ObjectUtils.isEmpty(cacheExecInfo.get(SmartAnalyseEnum.PV_QJHF.getKey()))) {
            result = "正在计算中";
        } else {
            MyServiceThread myServiceThread = new MyServiceThread(this, startTime, endTime, SmartAnalyseEnum.PV_QJHF.getKey());
            myServiceThread.start();
            cacheExecInfo.put(SmartAnalyseEnum.PV_QJHF.getKey(), myServiceThread);
        }
        return result;
    }

    //遍历工况列表数据-光伏
    public void getPvConditionVariablesByTime(String startTime, String endTime) {
        try {

            String startTimeUTC = getUtcTimeString(startTime);
            String endTimeUTC = getUtcTimeString(endTime);
            HashMap<String, List<IdxBizPvPointProcessVariableClassification>> idxBizPvPointProcessVariableClassificationHashMap = getIdxBizPvPointProcessVariableClassificationList();
            idxBizPvPointProcessVariableClassificationHashMap.keySet().forEach(s -> {
                List<IdxBizPvPointProcessVariableClassification> list = idxBizPvPointProcessVariableClassificationHashMap.get(s);
                if (list.size() > 0) {
                    foreachHandlerConditionVariabPv(s, list, startTime, endTime);
                }
            });
            cacheExecInfo.remove(SmartAnalyseEnum.FAN_QJHF.getKey());
        } catch (Exception exception) {
            cacheExecInfo.remove(SmartAnalyseEnum.FAN_QJHF.getKey());

        }
    }

    //遍历查询数据并调用并计算-风机
    public void foreachHandlerConditionVariabFan(String tableName, List<IdxBizFanPointProcessVariableClassification> list, String startTime, String endTime) {
        list.forEach(idxBizFanPointProcessVariableClassification -> {
            logger.info("--------------------------------------------风机：：开始查询influxdb--------------------------------");
            List<Map<String, Object>> params = new ArrayList<>();
           // String sql = String.format("select value from %s where address='%s' and  time >= '%s' and  time <= '%s' ", tableName, idxBizFanPointProcessVariableClassification.getIndexAddress(), startTime, endTime);
            List<IndicatorData> returnList = indicatorDataMapper.selectDataByAddressAndtime(idxBizFanPointProcessVariableClassification.getIndexAddress(), startTime, endTime,tableName);
            //List<Map<String, Object>> returnList = influxdbUtil.query(sql);
            returnList.forEach((k) -> {
                Map<String, Object> map = new HashMap<>();
                map.put("processVariable", Double.parseDouble(k.getValue()));
                map.put("processVariableId", Long.parseLong(idxBizFanPointProcessVariableClassification.getSequenceNbr()));
                params.add(map);
            });
            if (!params.isEmpty()) {
                logger.info("------------------------------------------风机：：开始调用工况变量区间划分算法----------------------------------------");
                HashMap<String, Object> realParams = new HashMap<>();
                realParams.put(gkqjhfkey, params);
                String response = HttpUtil.createPost(baseUrl + gkqjhfurlfan).body(JSON.toJSONString(realParams)).execute().body();
                if (response.contains("\"status\":200") && response.contains("rows") && response.contains("rows")) {
                    JSONObject jsonObject = JSONObject.parseObject(response);
                    JSONObject result = (JSONObject) jsonObject.get("result");
                    JSONObject result1 = (JSONObject) result.get("result1");
                    JSONArray rows = (JSONArray) result1.get("rows");
                    JSONObject values = rows.getJSONObject(0);
                    idxBizFanPointProcessVariableClassification.setRecDate(new Date());
                    idxBizFanPointProcessVariableClassification.setIntervalValue5(values.getDoubleValue("intervalValue5"));
                    idxBizFanPointProcessVariableClassification.setIntervalValue4(values.getDoubleValue("intervalValue4"));
                    idxBizFanPointProcessVariableClassification.setIntervalValue3(values.getDoubleValue("intervalValue3"));
                    idxBizFanPointProcessVariableClassification.setIntervalValue2(values.getDoubleValue("intervalValue2"));
                    idxBizFanPointProcessVariableClassification.setIntervalValue1(values.getDoubleValue("intervalValue1"));
                    idxBizFanPointProcessVariableClassificationMapper.updateById(idxBizFanPointProcessVariableClassification);
                    logger.info("------------------------------------------风机：：工况变量区间划分更新业务表成功----------------------------------------");
                }
                try {
                    logger.info(response);
                    TimeUnit.SECONDS.sleep(sleepTime);
                    logger.info("------------------------------------------风机：：调用工况变量区间划分算法结束----------------------------------------");
                } catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });

    }

    //遍历查询数据并调用并计算-光伏
    public void foreachHandlerConditionVariabPv(String tableName, List<IdxBizPvPointProcessVariableClassification> list, String startTime, String endTime) {
        list.forEach(idxBizPvPointProcessVariableClassification -> {
            logger.info("--------------------------------------------光伏：：开始查询influxdb--------------------------------");
            List<Map<String, Object>> params = new ArrayList<>();
          /*  String sql = String.format("select value from %s where address='%s' and  time >= '%s' and time <= '%s'  ", tableName, idxBizPvPointProcessVariableClassification.getIndexAddress(), startTime, endTime);
            List<Map<String, Object>> returnList = influxdbUtil.query(sql);*/
            List<IndicatorData> returnList = indicatorDataMapper.selectDataByAddressAndtime(idxBizPvPointProcessVariableClassification.getIndexAddress(), startTime, endTime,tableName);

            returnList.forEach((k) -> {
                Map<String, Object> map = new HashMap<>();
                map.put("processVariable", Double.parseDouble(k.getValue()));
                map.put("processVariableId", Long.parseLong(idxBizPvPointProcessVariableClassification.getSequenceNbr()));
                params.add(map);
            });
            if (!params.isEmpty()) {
                logger.info("------------------------------------------光伏：：开始调用工况变量区间划分算法----------------------------------------");
                HashMap<String, Object> realParams = new HashMap<>();
                realParams.put(gkqjhfkey, params);
                String response = HttpUtil.createPost(baseUrl + gkqjhfurlpv).body(JSON.toJSONString(realParams)).execute().body();
                if (response.contains("\"status\":200") && response.contains("rows")) {
                    JSONObject jsonObject = JSONObject.parseObject(response);
                    JSONObject result = (JSONObject) jsonObject.get("result");
                    JSONObject result1 = (JSONObject) result.get("result1");
                    JSONArray rows = (JSONArray) result1.get("rows");
                    JSONObject values = rows.getJSONObject(0);
                    idxBizPvPointProcessVariableClassification.setRecDate(new Date());
                    idxBizPvPointProcessVariableClassification.setIntervalValue5(values.getDoubleValue("intervalValue5"));
                    idxBizPvPointProcessVariableClassification.setIntervalValue4(values.getDoubleValue("intervalValue4"));
                    idxBizPvPointProcessVariableClassification.setIntervalValue3(values.getDoubleValue("intervalValue3"));
                    idxBizPvPointProcessVariableClassification.setIntervalValue2(values.getDoubleValue("intervalValue2"));
                    idxBizPvPointProcessVariableClassification.setIntervalValue1(values.getDoubleValue("intervalValue1"));
                    idxBizPvPointProcessVariableClassificationMapper.updateById(idxBizPvPointProcessVariableClassification);
                    logger.info("------------------------------------------风机：：工况变量区间划分更新业务表成功----------------------------------------");
                }
                try {
                    logger.info(response);
                    TimeUnit.SECONDS.sleep(sleepTime);
                    logger.info("------------------------------------------光伏：：调用工况变量区间划分算法结束----------------------------------------");
                } catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });

    }

    //获取相关性基础数据-风机
    public HashMap<String, List<IdxBizFanPointProcessVariableClassification>> getIdxBizFanPointProcessVariableClassificationListOfAnaLyse() {

        HashMap<String, List<IdxBizFanPointProcessVariableClassification>> IdxBizFanPointProcessVariableClassificationHashMap = new HashMap<>();
        List<String> gateWayIdList = idxBizFanPointProcessVariableClassificationMapper.gateWayIdListFan();
        List<IdxBizFanPointProcessVariableClassification> IdxBizFanPointProcessVariableClassificationListFengxi = idxBizFanPointProcessVariableClassificationMapper.selectList(new QueryWrapper<IdxBizFanPointProcessVariableClassification>().isNotNull("SEQUENCE_NBR").eq("TAG_CODE", "分析变量"));
        List<IdxBizFanPointProcessVariableClassification> finalIdxBizFanPointProcessVariableClassificationList = IdxBizFanPointProcessVariableClassificationListFengxi;
        gateWayIdList.forEach(s -> {
            IdxBizFanPointProcessVariableClassificationHashMap.put(s, finalIdxBizFanPointProcessVariableClassificationList.stream().filter(IdxBizFanPointProcessVariableClassification -> IdxBizFanPointProcessVariableClassification.getGatewayId().toString().equals(s)).collect(Collectors.toList()));
        });
        return IdxBizFanPointProcessVariableClassificationHashMap;
    }

    //获取相关性基础数据-光伏
    public HashMap<String, List<IdxBizPvPointProcessVariableClassification>> getIdxBizPvPointProcessVariableClassificationListOfAnaLyse() {

        HashMap<String, List<IdxBizPvPointProcessVariableClassification>> idxBizPvPointProcessVariableClassificationHashMap = new HashMap<>();
        List<String> gateWayIdList = idxBizPvPointProcessVariableClassificationMapper.gateWayIdListPv();
        List<IdxBizPvPointProcessVariableClassification> idxBizPvPointProcessVariableClassificationListFengxi = idxBizPvPointProcessVariableClassificationMapper.selectList(new QueryWrapper<IdxBizPvPointProcessVariableClassification>().isNotNull("SEQUENCE_NBR").eq("TAG_CODE", "分析变量"));
        List<IdxBizPvPointProcessVariableClassification> finalIdxBizPvPointProcessVariableClassificationList = idxBizPvPointProcessVariableClassificationListFengxi;
        gateWayIdList.forEach(s -> {
            idxBizPvPointProcessVariableClassificationHashMap.put(s, finalIdxBizPvPointProcessVariableClassificationList.stream().filter(idxBizPvPointProcessVariableClassification -> idxBizPvPointProcessVariableClassification.getGatewayId().toString().equals(s)).collect(Collectors.toList()));
        });
        return idxBizPvPointProcessVariableClassificationHashMap;
    }

    public String getFanConditionVariablesByTimeAnalyseThread(String startTime, String endTime) {
        String result = "开始计算";
        if (!ObjectUtils.isEmpty(cacheExecInfo.get(SmartAnalyseEnum.FAN_XGX.getKey()))) {
            result = "正在计算中";
        } else {
            MyServiceThread myServiceThread = new MyServiceThread(this, startTime, endTime, SmartAnalyseEnum.FAN_XGX.getKey());
            myServiceThread.start();
            cacheExecInfo.put(SmartAnalyseEnum.FAN_XGX.getKey(), myServiceThread);
        }
        return result;
    }

    //相关性分析-风机入口
    public void getFanConditionVariablesByTimeAnalyse(String startTime, String endTime) {
        try {
//            String startTimeUTC = getUtcTimeString(startTime);
//            String endTimeUTC = getUtcTimeString(endTime);
            HashMap<String, List<IdxBizFanPointProcessVariableClassification>> idxBizFanPointProcessVariableClassificationHashMap = getIdxBizFanPointProcessVariableClassificationListOfAnaLyse();
            idxBizFanPointProcessVariableClassificationHashMap.keySet().forEach(s -> {
                List<IdxBizFanPointProcessVariableClassification> list = idxBizFanPointProcessVariableClassificationHashMap.get(s);
                list.forEach(IdxBizFanPointProcessVariableClassification -> {
                    List<IdxBizFanPointVarCorrelation> gongkuangList = idxBizFanPointVarCorrelationMapper.selectList(new QueryWrapper<IdxBizFanPointVarCorrelation>().eq("ANALYSIS_GATEWAY_ID", IdxBizFanPointProcessVariableClassification.getGatewayId()).eq("ANALYSIS_POINT_ID", IdxBizFanPointProcessVariableClassification.getSequenceNbr()));
                    if (gongkuangList.size() > 0) {
                        foreachHandlerConditionVariabAnalyseFan(s, gongkuangList, startTime, endTime, IdxBizFanPointProcessVariableClassification);
                    }
                });
            });
            cacheExecInfo.remove(SmartAnalyseEnum.FAN_XGX.getKey());
        } catch (Exception exception) {
            cacheExecInfo.remove(SmartAnalyseEnum.PV_XGX.getKey());
        }
    }

    public String getPvConditionVariablesByTimeAnalyseThread(String startTime, String endTime) {
        String result = "开始计算";
        if (!ObjectUtils.isEmpty(cacheExecInfo.get(SmartAnalyseEnum.PV_XGX.getKey()))) {
            result = "正在计算中";
        } else {
            MyServiceThread myServiceThread = new MyServiceThread(this, startTime, endTime, SmartAnalyseEnum.PV_XGX.getKey());
            myServiceThread.start();
            cacheExecInfo.put(SmartAnalyseEnum.PV_XGX.getKey(), myServiceThread);
        }
        return result;
    }

    //相关性分析-光伏入口
    public void getPvConditionVariablesByTimeAnalyse(String startTime, String endTime) {
        try {
//            String startTimeUTC = getUtcTimeString(startTime);
//            String endTimeUTC = getUtcTimeString(endTime);
            HashMap<String, List<IdxBizPvPointProcessVariableClassification>> idxBizPvPointProcessVariableClassificationHashMap = getIdxBizPvPointProcessVariableClassificationListOfAnaLyse();
            idxBizPvPointProcessVariableClassificationHashMap.keySet().forEach(s -> {
                List<IdxBizPvPointProcessVariableClassification> list = idxBizPvPointProcessVariableClassificationHashMap.get(s);
                list.forEach(idxBizPvPointProcessVariableClassification -> {
                    List<IdxBizPvPointVarCorrelation> gongkuangList = idxBizPvPointVarCorrelationMapper.selectList(new QueryWrapper<IdxBizPvPointVarCorrelation>().eq("ANALYSIS_GATEWAY_ID", idxBizPvPointProcessVariableClassification.getGatewayId()).eq("ANALYSIS_POINT_ID", idxBizPvPointProcessVariableClassification.getSequenceNbr()));
                    if (gongkuangList.size() > 0) {
                        foreachHandlerConditionVariabAnalysePv(s, gongkuangList, startTime, endTime, idxBizPvPointProcessVariableClassification);
                    }
                });
            });
            cacheExecInfo.remove(SmartAnalyseEnum.PV_XGX.getKey());
        } catch (Exception exception) {
            cacheExecInfo.remove(SmartAnalyseEnum.PV_XGX.getKey());
        }
    }

    //遍历处理数据-组装风机
    public void foreachHandlerConditionVariabAnalyseFan(String tableName, List<IdxBizFanPointVarCorrelation> list, String startTime, String endTime, IdxBizFanPointProcessVariableClassification idxBizFanPointProcessVariableClassification) {

       //  String sql1 = String.format("select value from %s where address='%s' and  time >= '%s' and  time <= '%s' ", tableName, idxBizFanPointProcessVariableClassification.getIndexAddress(), startTime, endTime);
       // List<Map<String, Object>> returnList = influxdbUtil.query(sql1);
        List<IndicatorData> returnList = indicatorDataMapper.selectDataByAddressAndtime(idxBizFanPointProcessVariableClassification.getIndexAddress(), startTime, endTime,tableName);

        List<Map<String, Object>> params = new ArrayList<>();
        returnList.forEach((k) -> {
            Map<String, Object> map = new HashMap<>();
            map.put("analysisVariable", Double.parseDouble(k.getValue()));
            map.put("analysisVariableId", Long.parseLong(idxBizFanPointProcessVariableClassification.getSequenceNbr()));
            params.add(map);
        });
        List<Map<String, Object>> tempParams = params;
        list.forEach(idxBizFanPointVarCorrelation -> {
            logger.info("---------------------------------风机相关性-----------开始查询influxdb--------------------------------");
            List<Map<String, Object>> params1 = new ArrayList<>();
            List<Map<String, Object>> requestParams = new ArrayList<>();
          //  String sql = String.format("select value from %s where address='%s' and  time >= '%s' and  time <= '%s' ", tableName, idxBizFanPointVarCorrelation.getProcessIndexAddress(), startTime, endTime);
            List<IndicatorData> returnList1 = indicatorDataMapper.selectDataByAddressAndtime(idxBizFanPointVarCorrelation.getProcessIndexAddress(), startTime, endTime,tableName);

         //   List<Map<String, Object>> returnList1 = influxdbUtil.query(sql);
            returnList1.forEach((k) -> {
                Map<String, Object> map = new HashMap<>();
                map.put("processVariable", Double.parseDouble(k.getValue()));
                map.put("processVariableId", Long.parseLong(idxBizFanPointVarCorrelation.getProcessPointId().toString()));
                params1.add(map);
            });

            if (tempParams.size() >= params1.size()) {
                requestParams = megreMapList(tempParams, params1);
            } else {
                requestParams = megreMapList(params1, tempParams);
            }
            if (!requestParams.isEmpty()) {
                logger.info("------------------------------风机相关性------------分析变量与工况变量相关性分析算法开始----------------------------------------");
                HashMap<String, Object> realParams = new HashMap<>();
                realParams.put(gkxgxfxkey, requestParams);
                logger.info("------------------------------风机相关性------------分析变量与工况变量相关性分析算参数---------------------------------------" + JSON.toJSONString(realParams));
                String response = HttpUtil.createPost(baseUrl + gkxgxfxurlfan).body(JSON.toJSONString(realParams)).execute().body();
                if (response.contains("\"status\":200") && response.contains("rows")) {
                    JSONObject jsonObject = JSONObject.parseObject(response);
                    JSONObject result = (JSONObject) jsonObject.get("result");
                    JSONObject result1 = (JSONObject) result.get("result1");
                    JSONArray rows = (JSONArray) result1.get("rows");
                    JSONObject values = rows.getJSONObject(0);
                    idxBizFanPointVarCorrelation.setRecDate(new Date());
                    idxBizFanPointVarCorrelation.setCorrelationCoefficient(values.getDoubleValue("correlation_coefficient"));
                    idxBizFanPointVarCorrelationMapper.updateById(idxBizFanPointVarCorrelation);
                    logger.info("------------------------------------------风机相关性：：相关性更新业务表成功----------------------------------------");
                }
                try {
                    logger.info("response-------------" + response);
                    TimeUnit.SECONDS.sleep(sleepTime);
                    logger.info("----------------------------风机相关性--------------分析变量与工况变量相关性分析算法结束----------------------------------------");
                } catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    //遍历处理数据-组装风机
    public void foreachHandlerConditionVariabAnalysePv(String tableName, List<IdxBizPvPointVarCorrelation> list, String startTime, String endTime, IdxBizPvPointProcessVariableClassification idxBizPvPointProcessVariableClassification) {
        //    String sql1 = String.format("select value from %s where address='%s' and  time >= '%s' and time <= '%s' ", tableName, idxBizPvPointProcessVariableClassification.getIndexAddress(), startTime, endTime);
        //   List<Map<String, Object>> returnList = influxdbUtil.query(sql1);
        List<IndicatorData> returnList = indicatorDataMapper.selectDataByAddressAndtime(idxBizPvPointProcessVariableClassification.getIndexAddress(), startTime, endTime,tableName);

        List<Map<String, Object>> params = new ArrayList<>();
        returnList.forEach((k) -> {
            Map<String, Object> map = new HashMap<>();
            map.put("analysisVariable", Double.parseDouble(k.getValue()));
            map.put("analysisVariableId", Long.parseLong(idxBizPvPointProcessVariableClassification.getSequenceNbr()));
            params.add(map);
        });
        list.forEach(idxBizPvPointVarCorrelation -> {
            logger.info("-------------------------------------光伏相关性-------开始查询influxdb--------------------------------");
            List<Map<String, Object>> params1 = new ArrayList<>();
            List<Map<String, Object>> requestParams = new ArrayList<>();

            //String sql = String.format("select value from %s where address='%s' and  time >= '%s' and  time <= '%s'  ", tableName, idxBizPvPointVarCorrelation.getProcessIndexAddress(), startTime, endTime);
            //List<Map<String, Object>> returnList1 = influxdbUtil.query(sql);
            returnList.forEach((k) -> {
                Map<String, Object> map = new HashMap<>();
                map.put("processVariable", Double.parseDouble(k.getValue()));
                map.put("processVariableId", Long.parseLong(idxBizPvPointVarCorrelation.getProcessPointId()));
                params1.add(map);
            });
            if (params.size() >= params1.size()) {
                requestParams = megreMapList(params, params1);
            } else {
                requestParams = megreMapList(params1, params);
            }
            if (!requestParams.isEmpty()) {
                logger.info("---------------------------------光伏相关性---------分析变量与工况变量相关性分析算法开始----------------------------------------");
                HashMap<String, Object> realParams = new HashMap<>();
                realParams.put(gkxgxfxkey, requestParams);
                String response = HttpUtil.createPost(baseUrl + gkxgxfxurlpv).body(JSON.toJSONString(realParams)).execute().body();
                if (response.contains("\"status\":200") && response.contains("rows")) {
                    JSONObject jsonObject = JSONObject.parseObject(response);
                    JSONObject result = (JSONObject) jsonObject.get("result");
                    JSONObject result1 = (JSONObject) result.get("result1");
                    JSONArray rows = (JSONArray) result1.get("rows");
                    JSONObject values = rows.getJSONObject(0);
                    idxBizPvPointVarCorrelation.setRecDate(new Date());
                    idxBizPvPointVarCorrelation.setCorrelationCoefficient(values.getDoubleValue("correlation_coefficient"));
                    idxBizPvPointVarCorrelationMapper.updateById(idxBizPvPointVarCorrelation);
                    logger.info("------------------------------------------风机相关性：：相关性更新业务表成功----------------------------------------");
                }
                try {
                    logger.info("response----光伏相关性---------" + response);
                    TimeUnit.SECONDS.sleep(sleepTime);
                    logger.info("----------------------------------光伏相关性--------分析变量与工况变量相关性分析算法结束----------------------------------------");
                } catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public List<Map<String, Object>> megreMapList(List<Map<String, Object>> longList, List<Map<String, Object>> shortList) {
        List<Map<String, Object>> resultList = new ArrayList<>();
        for (int i = 0; i < longList.size(); i++) {
            Map<String, Object> map = new HashMap<>();
            map.putAll(longList.get(i));
            Map<String, Object> mapOfShortList = new HashMap<>();
            if (i < shortList.size() - 1) {
                mapOfShortList.putAll(shortList.get(i));
            } else {
                mapOfShortList.putAll(shortList.get(shortList.size() - 1));
            }

            if (!map.containsKey("processVariable")) {
                map.put("processVariable", mapOfShortList.get("processVariable"));
                map.put("processVariableId", mapOfShortList.get("processVariableId"));
            } else {
                map.put("analysisVariable", mapOfShortList.get("analysisVariable"));
                map.put("analysisVariableId", mapOfShortList.get("analysisVariableId"));
            }
            resultList.add(map);
        }
        return resultList;
    }

    public String getFanConditionVariablesByTimeAnalyse1Thread(String startTime, String endTime) {
        String result = "开始计算";
        if (!ObjectUtils.isEmpty(cacheExecInfo.get(SmartAnalyseEnum.FAN_ZXZ.getKey()))) {
            result = "正在计算中";
        } else {
            MyServiceThread myServiceThread = new MyServiceThread(this, startTime, endTime, SmartAnalyseEnum.FAN_ZXZ.getKey());
            myServiceThread.start();
            cacheExecInfo.put(SmartAnalyseEnum.FAN_ZXZ.getKey(), myServiceThread);
        }
        return result;
    }

    //中心值计算-风电
    public void getFanConditionVariablesByTimeAnalyse1(String startTime, String endTime) {
        try {

//            String startTimeUTC = getUtcTimeString(startTime);
//            String endTimeUTC = getUtcTimeString(endTime);
            HashMap<String, List<IdxBizFanPointProcessVariableClassification>> IdxBizFanPointProcessVariableClassificationHashMap = getIdxBizFanPointProcessVariableClassificationListOfAnaLyse();
            IdxBizFanPointProcessVariableClassificationHashMap.keySet().forEach(s -> {
                List<IdxBizFanPointProcessVariableClassification> list = IdxBizFanPointProcessVariableClassificationHashMap.get(s);
                list.forEach(IdxBizFanPointProcessVariableClassification -> {
                    List<IdxBizFanPointVarCorrelation> gongkuangList = idxBizFanPointVarCorrelationMapper.selectList(new QueryWrapper<IdxBizFanPointVarCorrelation>().eq("ANALYSIS_GATEWAY_ID", IdxBizFanPointProcessVariableClassification.getGatewayId()).eq("ANALYSIS_POINT_ID", IdxBizFanPointProcessVariableClassification.getSequenceNbr()).orderByDesc("CORRELATION_COEFFICIENT").last("limit 0,3"));
                    if (gongkuangList.size() > 0) {
                        foreachHandlerConditionVariabAnalyse1Fan(s, gongkuangList, startTime, endTime, IdxBizFanPointProcessVariableClassification);
                    }
                });
            });
            cacheExecInfo.remove(SmartAnalyseEnum.FAN_ZXZ.getKey());
        } catch (Exception exception) {
            cacheExecInfo.remove(SmartAnalyseEnum.FAN_ZXZ.getKey());

        }
    }

    public String getPvConditionVariablesByTimeAnalyse1Thread(String startTime, String endTime) {
        String result = "开始计算";
        if (!ObjectUtils.isEmpty(cacheExecInfo.get(SmartAnalyseEnum.PV_ZXZ.getKey()))) {
            result = "正在计算中";
        } else {
            MyServiceThread myServiceThread = new MyServiceThread(this, startTime, endTime, SmartAnalyseEnum.PV_ZXZ.getKey());
            myServiceThread.start();
            cacheExecInfo.put(SmartAnalyseEnum.PV_ZXZ.getKey(), myServiceThread);
        }
        return result;
    }

    //中心值计算-光伏
    public void getPvConditionVariablesByTimeAnalyse1(String startTime, String endTime) {
        try {


//            String startTimeUTC = getUtcTimeString(startTime);
//            String endTimeUTC = getUtcTimeString(endTime);
            HashMap<String, List<IdxBizPvPointProcessVariableClassification>> idxBizPvPointProcessVariableClassificationHashMap = getIdxBizPvPointProcessVariableClassificationListOfAnaLyse();
            idxBizPvPointProcessVariableClassificationHashMap.keySet().forEach(s -> {
                List<IdxBizPvPointProcessVariableClassification> list = idxBizPvPointProcessVariableClassificationHashMap.get(s);
                list.forEach(idxBizPvPointProcessVariableClassification -> {
                    List<IdxBizPvPointVarCorrelation> gongkuangList = idxBizPvPointVarCorrelationMapper.selectList(new QueryWrapper<IdxBizPvPointVarCorrelation>().eq("ANALYSIS_GATEWAY_ID", idxBizPvPointProcessVariableClassification.getGatewayId()).eq("ANALYSIS_POINT_ID", idxBizPvPointProcessVariableClassification.getSequenceNbr()).orderByDesc("CORRELATION_COEFFICIENT").last("limit 0,3"));
                    if (gongkuangList.size() > 0) {
                        foreachHandlerConditionVariabAnalyse1Pv(s, gongkuangList, startTime, endTime, idxBizPvPointProcessVariableClassification);
                    }

                });
            });
            cacheExecInfo.remove(SmartAnalyseEnum.PV_ZXZ.getKey());
        } catch (Exception exception) {
            cacheExecInfo.remove(SmartAnalyseEnum.PV_ZXZ.getKey());
        }
    }

    //中心值参数组装-风电
    public void foreachHandlerConditionVariabAnalyse1Fan(String tableName, List<IdxBizFanPointVarCorrelation> list, String startTime, String endTime, IdxBizFanPointProcessVariableClassification IdxBizFanPointProcessVariableClassification) {
      //  String sql0 = String.format("select value from %s where address='%s' and  time >= '%s' and time <= '%s' ", tableName, IdxBizFanPointProcessVariableClassification.getIndexAddress(), startTime, endTime);
      //  List<Map<String, Object>> returnList = influxdbUtil.query(sql0);
        List<IndicatorData> returnList = indicatorDataMapper.selectDataByAddressAndtime(IdxBizFanPointProcessVariableClassification.getIndexAddress(), startTime, endTime,tableName);

        List<Map<String, Object>> params = new ArrayList<>();
        returnList.forEach((k) -> {
            Map<String, Object> map = new HashMap<>();
            map.put("analysisVariable", Double.parseDouble(k.getValue()));
            map.put("analysisVariableId", (IdxBizFanPointProcessVariableClassification.getSequenceNbr().toString()));
            params.add(map);
        });
        logger.info("--------------------------------------风机中心值------开始查询influxdb--------------------------------");
        List<Map<String, Object>> params1 = new ArrayList<>();
        List<Map<String, Object>> requestParams = new ArrayList<>();
//            String sql = String.format("select value from %s where address='%s' and where time >= '%s' and where time <= '%s' ", tableName, IdxBizFanPointProcessVariableClassification.getIndexAddress(), startTime, endTime);
//        String sql = String.format("select value from %s where address='%s' and  time >= '%s' and time <= '%s'  ", tableName, list.get(0).getProcessIndexAddress(), startTime, endTime);
//        String sql1 = String.format("select value from %s where address='%s' and  time >= '%s' and time <= '%s' ", tableName, list.get(1).getProcessIndexAddress(), startTime, endTime);
//        String sql2 = String.format("select value from %s where address='%s' and  time >= '%s' and time <= '%s' ", tableName, list.get(2).getProcessIndexAddress(), startTime, endTime);
        List<HashMap<String, Object>> values = new ArrayList<>();
        List<String> processPointIds = list.stream().map(idxBizFanPointVarCorrelation -> idxBizFanPointVarCorrelation.getProcessPointId().toString()).collect(Collectors.toList());
        List<IdxBizFanPointProcessVariableClassification> idxBizFanPointProcessVariableClassificationList = idxBizFanPointProcessVariableClassificationMapper.selectList(new QueryWrapper<IdxBizFanPointProcessVariableClassification>().in("SEQUENCE_NBR", processPointIds));
        //区间值1
        HashMap<String, Object> value1 = new HashMap<>();
        value1.put("processVariable1", ObjectUtils.isEmpty(idxBizFanPointProcessVariableClassificationList.get(2).getIntervalValue1()) ? 0.0 : idxBizFanPointProcessVariableClassificationList.get(2).getIntervalValue1());
        value1.put("processVariable2", ObjectUtils.isEmpty(idxBizFanPointProcessVariableClassificationList.get(1).getIntervalValue1()) ? 0.0 : idxBizFanPointProcessVariableClassificationList.get(1).getIntervalValue1());
        value1.put("processVariable3", ObjectUtils.isEmpty(idxBizFanPointProcessVariableClassificationList.get(0).getIntervalValue1()) ? 0.0 : idxBizFanPointProcessVariableClassificationList.get(0).getIntervalValue1());
        values.add(value1);
        //区间值2
        HashMap<String, Object> value2 = new HashMap<>();
        value2.put("processVariable1", ObjectUtils.isEmpty(idxBizFanPointProcessVariableClassificationList.get(2).getIntervalValue2()) ? 0.0 : idxBizFanPointProcessVariableClassificationList.get(2).getIntervalValue2());
        value2.put("processVariable2", ObjectUtils.isEmpty(idxBizFanPointProcessVariableClassificationList.get(1).getIntervalValue2()) ? 0.0 : idxBizFanPointProcessVariableClassificationList.get(1).getIntervalValue2());
        value2.put("processVariable3", ObjectUtils.isEmpty(idxBizFanPointProcessVariableClassificationList.get(0).getIntervalValue2()) ? 0.0 : idxBizFanPointProcessVariableClassificationList.get(0).getIntervalValue2());
        values.add(value2);
        //区间值3
        HashMap<String, Object> value3 = new HashMap<>();
        value3.put("processVariable1", ObjectUtils.isEmpty(idxBizFanPointProcessVariableClassificationList.get(2).getIntervalValue3()) ? 0.0 : idxBizFanPointProcessVariableClassificationList.get(2).getIntervalValue3());
        value3.put("processVariable2", ObjectUtils.isEmpty(idxBizFanPointProcessVariableClassificationList.get(1).getIntervalValue3()) ? 0.0 : idxBizFanPointProcessVariableClassificationList.get(1).getIntervalValue3());
        value3.put("processVariable3", ObjectUtils.isEmpty(idxBizFanPointProcessVariableClassificationList.get(0).getIntervalValue3()) ? 0.0 : idxBizFanPointProcessVariableClassificationList.get(0).getIntervalValue3());
        values.add(value3);
        //区间值4
        HashMap<String, Object> value4 = new HashMap<>();
        value4.put("processVariable1", ObjectUtils.isEmpty(idxBizFanPointProcessVariableClassificationList.get(2).getIntervalValue4()) ? 0.0 : idxBizFanPointProcessVariableClassificationList.get(2).getIntervalValue4());
        value4.put("processVariable2", ObjectUtils.isEmpty(idxBizFanPointProcessVariableClassificationList.get(1).getIntervalValue4()) ? 0.0 : idxBizFanPointProcessVariableClassificationList.get(1).getIntervalValue4());
        value4.put("processVariable3", ObjectUtils.isEmpty(idxBizFanPointProcessVariableClassificationList.get(0).getIntervalValue4()) ? 0.0 : idxBizFanPointProcessVariableClassificationList.get(0).getIntervalValue4());
        values.add(value4);
        //区间值5
        HashMap<String, Object> value5 = new HashMap<>();
        value5.put("processVariable1", ObjectUtils.isEmpty(idxBizFanPointProcessVariableClassificationList.get(2).getIntervalValue5()) ? 0.0 : idxBizFanPointProcessVariableClassificationList.get(2).getIntervalValue5());
        value5.put("processVariable2", ObjectUtils.isEmpty(idxBizFanPointProcessVariableClassificationList.get(1).getIntervalValue5()) ? 0.0 : idxBizFanPointProcessVariableClassificationList.get(1).getIntervalValue5());
        value5.put("processVariable3", ObjectUtils.isEmpty(idxBizFanPointProcessVariableClassificationList.get(0).getIntervalValue5()) ? 0.0 : idxBizFanPointProcessVariableClassificationList.get(0).getIntervalValue5());
        values.add(value5);
        List<IndicatorData> returnList0 = indicatorDataMapper.selectDataByAddressAndtime(list.get(0).getProcessIndexAddress(), startTime, endTime,tableName);
        List<IndicatorData> returnList1 = indicatorDataMapper.selectDataByAddressAndtime(list.get(1).getProcessIndexAddress(), startTime, endTime,tableName);
        List<IndicatorData> returnList2 = indicatorDataMapper.selectDataByAddressAndtime(list.get(2).getProcessIndexAddress(), startTime, endTime,tableName);

       // List<Map<String, Object>> returnList0 = influxdbUtil.query(sql);
        List<IndicatorData> maxList = returnList0;
      //  List<Map<String, Object>> returnList1 = influxdbUtil.query(sql);
        maxList = maxList.size() > returnList1.size() ? maxList : returnList1;
      //  List<Map<String, Object>> returnList2 = influxdbUtil.query(sql);
        maxList = maxList.size() > returnList2.size() ? maxList : returnList2;
        for (int j = 0; j < maxList.size(); j++) {
            Map<String, Object> map = new HashMap<>();
            IndicatorData map1 = new IndicatorData();
            IndicatorData map2 = new IndicatorData();
            IndicatorData map3 = new IndicatorData();
            if (j < returnList0.size() - 1) {
                map1 =   returnList0.get(j);
            } else {
                map1 = returnList0.get(returnList0.size() - 1);
            }
            if (j < returnList1.size() - 1) {
                map2 = returnList1.get(j);
            } else {
                map2 = returnList1.get(returnList1.size() - 1);
            }
            if (j < returnList2.size() - 1) {
                map3 = returnList2.get(j);
            } else {
                map3 = returnList2.get(returnList2.size() - 1);
            }
            map.put("processVariable1", Double.parseDouble(map1.getValue()));
            map.put("processVariable1Id", list.get(0).getProcessPointId().toString());
            map.put("processVariable2", Double.parseDouble(map2.getValue()));
            map.put("processVariable2Id", list.get(1).getProcessPointId().toString());
            map.put("processVariable3", Double.parseDouble(map3.getValue()));
            map.put("processVariable3Id", list.get(2).getProcessPointId().toString());
            params1.add(map);
        }
        if (params.size() >= params1.size()) {
            requestParams = megreMapList1(params, params1);
        } else {
            requestParams = megreMapList1(params1, params);
        }
        if (!requestParams.isEmpty()) {
            logger.info("---------------------------------风机中心值---------开始调用中心值计算算法开始----------------------------------------");
            HashMap<String, Object> realParams = new HashMap<>();
            realParams.put(gkzxzjskey1, values);
            realParams.put(gkzxzjskey2, requestParams);
            logger.info("------------------------------风机中心值------请求参数---------------------------------------" + JSON.toJSONString(realParams));
            String response = HttpUtil.createPost(baseUrl + gkzxzjsurlfan).body(JSON.toJSONString(realParams)).execute().body();
            if (response.contains("\"status\":200") && response.contains("rows")) {
                JSONObject jsonObject = JSONObject.parseObject(response);
                JSONObject result = (JSONObject) jsonObject.get("result");
                JSONObject result1 = (JSONObject) result.get("result1");
                JSONArray rows = (JSONArray) result1.get("rows");
                JSONObject resultValues = rows.getJSONObject(0);
                idxBizFanPointVarCentralValueMapper.delete(new QueryWrapper<IdxBizFanPointVarCentralValue>().eq("ANALYSIS_POINT_ID", resultValues.get("analysisVariableId")));
                for (int i = 0; i < rows.size(); i++) {
                    JSONObject idxCentralValue = rows.getJSONObject(i);
                    IdxBizFanPointVarCentralValue idxBizFanPointVarCentralValue = new IdxBizFanPointVarCentralValue();
                    idxBizFanPointVarCentralValue.setProcess1Min(idxCentralValue.getDoubleValue("process1Min"));
                    idxBizFanPointVarCentralValue.setProcess2Min(idxCentralValue.getDoubleValue("process2Min"));
                    idxBizFanPointVarCentralValue.setProcess3Min(idxCentralValue.getDoubleValue("process3Min"));
                    idxBizFanPointVarCentralValue.setProcess1Max(idxCentralValue.getDoubleValue("process1Max"));
                    idxBizFanPointVarCentralValue.setPorcess2Max(idxCentralValue.getDoubleValue("process2Max"));
                    idxBizFanPointVarCentralValue.setProcess3Max(idxCentralValue.getDoubleValue("process3Max"));
                    idxBizFanPointVarCentralValue.setAnalysisPointId(idxCentralValue.getString("analysisVariableId"));
                    idxBizFanPointVarCentralValue.setAnalysisPointName(IdxBizFanPointProcessVariableClassification.getPointName());
                    idxBizFanPointVarCentralValue.setProcessPoint1Id(idxCentralValue.getString("processVariable1Id"));
                    idxBizFanPointVarCentralValue.setProcessPoint1Name(idxBizFanPointProcessVariableClassificationList.get(2).getPointName());
                    idxBizFanPointVarCentralValue.setProcessPoint2Id(idxCentralValue.getString("processVariable2Id"));
                    idxBizFanPointVarCentralValue.setProcessPoint2Name(idxBizFanPointProcessVariableClassificationList.get(1).getPointName());
                    idxBizFanPointVarCentralValue.setProcessPoint3Id(idxCentralValue.getString("processVariable3Id"));
                    idxBizFanPointVarCentralValue.setProcessPoint3Name(idxBizFanPointProcessVariableClassificationList.get(0).getPointName());
                    idxBizFanPointVarCentralValue.setAnalysisStdDev(idxCentralValue.getDoubleValue("stdDev"));
                    idxBizFanPointVarCentralValue.setAnalysisCenterValue(idxCentralValue.getDoubleValue("centerValue"));
                    idxBizFanPointVarCentralValue.setArae(IdxBizFanPointProcessVariableClassification.getArae());
                    idxBizFanPointVarCentralValue.setStation(IdxBizFanPointProcessVariableClassification.getStation());
                    idxBizFanPointVarCentralValue.setSubSystem(IdxBizFanPointProcessVariableClassification.getSubSystem());
                    idxBizFanPointVarCentralValue.setNumber(IdxBizFanPointProcessVariableClassification.getNumber());
                    idxBizFanPointVarCentralValue.setEquipmentName(IdxBizFanPointProcessVariableClassification.getEquipmentName());
                    idxBizFanPointVarCentralValueMapper.insert(idxBizFanPointVarCentralValue);
                }
                logger.info("------------------------------------------风机中心值：：中心值更新业务表成功----------------------------------------");
            }

            try {
                logger.info("------------------风机中心值--response： " + response);
                TimeUnit.SECONDS.sleep(zxzsleepTime);
                logger.info("-----------------------------------风机中心值-------调用中心值计算算法结束----------------------------------------");
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    //中心值参数组装-光伏
    public void foreachHandlerConditionVariabAnalyse1Pv(String tableName, List<IdxBizPvPointVarCorrelation> list, String startTime, String endTime, IdxBizPvPointProcessVariableClassification idxBizPvPointProcessVariableClassification) {
        List<IndicatorData> returnList = indicatorDataMapper.selectDataByAddressAndtime(idxBizPvPointProcessVariableClassification.getIndexAddress(), startTime, endTime,tableName);

        //String sql0 = String.format("select value from %s where address='%s' and  time >= '%s' and time <= '%s' ", tableName, idxBizPvPointProcessVariableClassification.getIndexAddress(), startTime, endTime);
        //List<Map<String, Object>> returnList = influxdbUtil.query(sql0);
        List<Map<String, Object>> params = new ArrayList<>();

        returnList.forEach((k) -> {
            Map<String, Object> map = new HashMap<>();
            map.put("analysisVariable", Double.parseDouble(k.getValue()));
            map.put("analysisVariableId", Long.parseLong(idxBizPvPointProcessVariableClassification.getSequenceNbr()));
            params.add(map);
        });
        logger.info("-----------------------------------光伏中心值---------开始查询influxdb--------------------------------");
        List<Map<String, Object>> params1 = new ArrayList<>();
        List<Map<String, Object>> requestParams = new ArrayList<>();
//        String sql = String.format("select value from %s where address='%s' and  time >= '%s' and time <= '%s' ", tableName, list.get(0).getProcessIndexAddress(), startTime, endTime);
//        String sql1 = String.format("select value from %s where address='%s' and  time >= '%s' and time <= '%s' ", tableName, list.get(1).getProcessIndexAddress(), startTime, endTime);
//        String sql2 = String.format("select value from %s where address='%s' and  time >= '%s' and time <= '%s' ", tableName, list.get(2).getProcessIndexAddress(), startTime, endTime);
        List<IndicatorData> returnList0 = indicatorDataMapper.selectDataByAddressAndtime(list.get(0).getProcessIndexAddress(), startTime, endTime,tableName);
        List<IndicatorData> returnList1 = indicatorDataMapper.selectDataByAddressAndtime(list.get(1).getProcessIndexAddress(), startTime, endTime,tableName);
        List<IndicatorData> returnList2 = indicatorDataMapper.selectDataByAddressAndtime(list.get(2).getProcessIndexAddress(), startTime, endTime,tableName);

        List<HashMap<String, Object>> values = new ArrayList<>();
        List<String> processPointIds = list.stream().map(idxBizPvPointVarCorrelation -> idxBizPvPointVarCorrelation.getProcessPointId().toString()).collect(Collectors.toList());
        List<IdxBizPvPointProcessVariableClassification> idxBizPvPointProcessVariableClassificationList = idxBizPvPointProcessVariableClassificationMapper.selectList(new QueryWrapper<IdxBizPvPointProcessVariableClassification>().in("SEQUENCE_NBR", processPointIds));
        //区间值1
        HashMap<String, Object> value1 = new HashMap<>();
        value1.put("processVariable1", ObjectUtils.isEmpty(idxBizPvPointProcessVariableClassificationList.get(2).getIntervalValue1()) ? 0.0 : idxBizPvPointProcessVariableClassificationList.get(2).getIntervalValue1());
        value1.put("processVariable2", ObjectUtils.isEmpty(idxBizPvPointProcessVariableClassificationList.get(1).getIntervalValue1()) ? 0.0 : idxBizPvPointProcessVariableClassificationList.get(1).getIntervalValue1());
        value1.put("processVariable3", ObjectUtils.isEmpty(idxBizPvPointProcessVariableClassificationList.get(0).getIntervalValue1()) ? 0.0 : idxBizPvPointProcessVariableClassificationList.get(0).getIntervalValue1());
        values.add(value1);
        //区间值2
        HashMap<String, Object> value2 = new HashMap<>();
        value2.put("processVariable1", ObjectUtils.isEmpty(idxBizPvPointProcessVariableClassificationList.get(2).getIntervalValue2()) ? 0.0 : idxBizPvPointProcessVariableClassificationList.get(2).getIntervalValue2());
        value2.put("processVariable2", ObjectUtils.isEmpty(idxBizPvPointProcessVariableClassificationList.get(1).getIntervalValue2()) ? 0.0 : idxBizPvPointProcessVariableClassificationList.get(1).getIntervalValue2());
        value2.put("processVariable3", ObjectUtils.isEmpty(idxBizPvPointProcessVariableClassificationList.get(0).getIntervalValue2()) ? 0.0 : idxBizPvPointProcessVariableClassificationList.get(0).getIntervalValue2());
        values.add(value2);
        //区间值3
        HashMap<String, Object> value3 = new HashMap<>();
        value3.put("processVariable1", ObjectUtils.isEmpty(idxBizPvPointProcessVariableClassificationList.get(2).getIntervalValue3()) ? 0.0 : idxBizPvPointProcessVariableClassificationList.get(2).getIntervalValue3());
        value3.put("processVariable2", ObjectUtils.isEmpty(idxBizPvPointProcessVariableClassificationList.get(1).getIntervalValue3()) ? 0.0 : idxBizPvPointProcessVariableClassificationList.get(1).getIntervalValue3());
        value3.put("processVariable3", ObjectUtils.isEmpty(idxBizPvPointProcessVariableClassificationList.get(0).getIntervalValue3()) ? 0.0 : idxBizPvPointProcessVariableClassificationList.get(0).getIntervalValue3());
        values.add(value3);
        //区间值4
        HashMap<String, Object> value4 = new HashMap<>();
        value4.put("processVariable1", ObjectUtils.isEmpty(idxBizPvPointProcessVariableClassificationList.get(2).getIntervalValue4()) ? 0.0 : idxBizPvPointProcessVariableClassificationList.get(2).getIntervalValue4());
        value4.put("processVariable2", ObjectUtils.isEmpty(idxBizPvPointProcessVariableClassificationList.get(1).getIntervalValue4()) ? 0.0 : idxBizPvPointProcessVariableClassificationList.get(1).getIntervalValue4());
        value4.put("processVariable3", ObjectUtils.isEmpty(idxBizPvPointProcessVariableClassificationList.get(0).getIntervalValue4()) ? 0.0 : idxBizPvPointProcessVariableClassificationList.get(0).getIntervalValue4());
        values.add(value4);
        //区间值5
        HashMap<String, Object> value5 = new HashMap<>();
        value5.put("processVariable1", ObjectUtils.isEmpty(idxBizPvPointProcessVariableClassificationList.get(2).getIntervalValue5()) ? 0.0 : idxBizPvPointProcessVariableClassificationList.get(2).getIntervalValue5());
        value5.put("processVariable2", ObjectUtils.isEmpty(idxBizPvPointProcessVariableClassificationList.get(1).getIntervalValue5()) ? 0.0 : idxBizPvPointProcessVariableClassificationList.get(1).getIntervalValue5());
        value5.put("processVariable3", ObjectUtils.isEmpty(idxBizPvPointProcessVariableClassificationList.get(0).getIntervalValue5()) ? 0.0 : idxBizPvPointProcessVariableClassificationList.get(0).getIntervalValue5());
        values.add(value5);
        //List<Map<String, Object>> returnList0 = influxdbUtil.query(sql);
        List<IndicatorData> maxList = returnList0;
        //List<Map<String, Object>> returnList1 = influxdbUtil.query(sql);
        maxList = maxList.size() > returnList1.size() ? maxList : returnList1;
        //List<Map<String, Object>> returnList2 = influxdbUtil.query(sql);
        maxList = maxList.size() > returnList2.size() ? maxList : returnList2;
        for (int j = 0; j < maxList.size(); j++) {
            Map<String, Object> map = new HashMap<>();
            IndicatorData map1 = new IndicatorData();
            IndicatorData map2 = new IndicatorData();
            IndicatorData map3 = new IndicatorData();
            if (j < returnList0.size() - 1) {
                map1 = returnList0.get(j);
            } else {
                map1 = returnList0.get(returnList0.size() - 1);
            }
            if (j < returnList1.size() - 1) {
                map2 = returnList1.get(j);
            } else {
                map2 = returnList1.get(returnList1.size() - 1);
            }
            if (j < returnList2.size() - 1) {
                map3 = returnList2.get(j);
            } else {
                map3 = returnList2.get(returnList2.size() - 1);
            }
            map.put("processVariable1", Double.parseDouble(map1.getValue()));
            map.put("processVariable1Id", Long.parseLong(list.get(0).getProcessPointId().toString()));
            map.put("processVariable2", Double.parseDouble(map2.getValue()));
            map.put("processVariable2Id", Long.parseLong(list.get(1).getProcessPointId().toString()));
            map.put("processVariable3", Double.parseDouble(map3.getValue()));
            map.put("processVariable3Id", Long.parseLong(list.get(2).getProcessPointId().toString()));
            params1.add(map);
        }
        if (params.size() >= params1.size()) {
            requestParams = megreMapList1(params, params1);
        } else {
            requestParams = megreMapList1(params1, params);
        }
        if (!requestParams.isEmpty()) {
            logger.info("-------------------------------------光伏中心值-----开始调用中心值计算算法----------------------------------------");
            HashMap<String, Object> realParams = new HashMap<>();
            realParams.put(gkzxzjskey1, values);
            realParams.put(gkzxzjskey2, requestParams);
            String response = HttpUtil.createPost(baseUrl + gkzxzjsurlpv).body(JSON.toJSONString(realParams)).execute().body();
            if (response.contains("\"status\":200") && response.contains("rows")) {
                JSONObject jsonObject = JSONObject.parseObject(response);
                JSONObject result = (JSONObject) jsonObject.get("result");
                JSONObject result1 = (JSONObject) result.get("result1");
                JSONArray rows = (JSONArray) result1.get("rows");
                JSONObject resultValues = rows.getJSONObject(0);
                idxBizPvPointVarCentralValueMapper.delete(new QueryWrapper<IdxBizPvPointVarCentralValue>().eq("ANALYSIS_POINT_ID", resultValues.get("analysisVariableId")));
                for (int i = 0; i < rows.size(); i++) {
                    JSONObject idxCentralValue = rows.getJSONObject(i);
                    IdxBizPvPointVarCentralValue idxBizPvPointVarCentralValue = new IdxBizPvPointVarCentralValue();
                    idxBizPvPointVarCentralValue.setProcess1Min(idxCentralValue.getDoubleValue("process1Min"));
                    idxBizPvPointVarCentralValue.setProcess2Min(idxCentralValue.getDoubleValue("process2Min"));
                    idxBizPvPointVarCentralValue.setProcess3Min(idxCentralValue.getDoubleValue("process3Min"));
                    idxBizPvPointVarCentralValue.setProcess1Max(idxCentralValue.getDoubleValue("process1Max"));
                    idxBizPvPointVarCentralValue.setProcess2Max(idxCentralValue.getDoubleValue("process2Max"));
                    idxBizPvPointVarCentralValue.setProcess3Max(idxCentralValue.getDoubleValue("process3Max"));
                    idxBizPvPointVarCentralValue.setAnalysisPointId(idxCentralValue.getString("analysisVariableId"));
                    idxBizPvPointVarCentralValue.setAnalysisPointIdName(idxBizPvPointProcessVariableClassification.getPointName());
                    idxBizPvPointVarCentralValue.setProcessPoint1Id(idxCentralValue.getString("processVariable1Id"));
                    idxBizPvPointVarCentralValue.setProcessPoint1IdName(idxBizPvPointProcessVariableClassificationList.get(2).getPointName());
                    idxBizPvPointVarCentralValue.setProcessPoint2Id(idxCentralValue.getString("processVariable2Id"));
                    idxBizPvPointVarCentralValue.setProcessPoint2IdName(idxBizPvPointProcessVariableClassificationList.get(1).getPointName());
                    idxBizPvPointVarCentralValue.setProcessPoint3Id(idxCentralValue.getString("processVariable3Id"));
                    idxBizPvPointVarCentralValue.setProcessPoint3IdName(idxBizPvPointProcessVariableClassificationList.get(0).getPointName());
                    idxBizPvPointVarCentralValue.setAnalysisStdDev(idxCentralValue.getDoubleValue("stdDev"));
                    idxBizPvPointVarCentralValue.setAnalysisCenterValue(idxCentralValue.getDoubleValue("centerValue"));
                    idxBizPvPointVarCentralValue.setArae(idxBizPvPointProcessVariableClassification.getArae());
                    idxBizPvPointVarCentralValue.setStation(idxBizPvPointProcessVariableClassification.getStation());
                    idxBizPvPointVarCentralValue.setSubarray(idxBizPvPointProcessVariableClassification.getSubarray());
                    idxBizPvPointVarCentralValue.setManufacturer(idxBizPvPointProcessVariableClassification.getManufacturer());
                    idxBizPvPointVarCentralValue.setEquipmentName(idxBizPvPointProcessVariableClassification.getEquipmentName());
                    idxBizPvPointVarCentralValueMapper.insert(idxBizPvPointVarCentralValue);
                }
                logger.info("------------------------------------------光伏中心值：：中心值更新业务表成功----------------------------------------");
            }
            try {
                logger.info("-------------光伏中心值-------response： " + response);
                TimeUnit.SECONDS.sleep(sleepTime);
                logger.info("-----------------------------------光伏中心值-------调用中心值计算算法结束----------------------------------------");
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }


    }

    public List<Map<String, Object>> megreMapList1(List<Map<String, Object>> longList, List<Map<String, Object>> shortList) {
        List<Map<String, Object>> resultList = new ArrayList<>();
        for (int i = 0; i < longList.size(); i++) {
            Map<String, Object> map = new HashMap<>();
            map.putAll(longList.get(i));
            Map<String, Object> mapOfShortList = new HashMap<>();
            if (i < shortList.size() - 1) {
                mapOfShortList.putAll(shortList.get(i));
            } else {
                mapOfShortList.putAll(shortList.get(shortList.size() - 1));
            }
            if (!map.containsKey("processVariable1")) {
                map.put("processVariable1", mapOfShortList.get("processVariable1"));
                map.put("processVariable1Id", mapOfShortList.get("processVariable1Id"));
                map.put("processVariable2", mapOfShortList.get("processVariable2"));
                map.put("processVariable2Id", mapOfShortList.get("processVariable2Id"));
                map.put("processVariable3", mapOfShortList.get("processVariable3"));
                map.put("processVariable3Id", mapOfShortList.get("processVariable3Id"));
            } else {
                map.put("analysisVariable", mapOfShortList.get("analysisVariable"));
                map.put("analysisVariableId", mapOfShortList.get("analysisVariableId"));
            }
            resultList.add(map);
        }
        return resultList;
    }

    public Map<String, Object> getInfluxdbDataByConditon(String stationType, String pointId, String startTime, String endTime) {
        HashMap<String, Object> resultLast = new HashMap();
        String sql = "";
        List<IndicatorData> result = new ArrayList<>();
        if ("FD".equals(stationType)) {
            IdxBizFanPointProcessVariableClassification idxBizFanPointProcessVariableClassification = idxBizFanPointProcessVariableClassificationMapper.selectOne(new QueryWrapper<IdxBizFanPointProcessVariableClassification>().eq("INDEX_ADDRESS", pointId).eq("TAG_CODE","分析变量"));
            result = indicatorDataMapper.selectDataByAddressAndtime(idxBizFanPointProcessVariableClassification.getIndexAddress(), startTime, endTime,idxBizFanPointProcessVariableClassification.getGatewayId());
        } else {
            IdxBizPvPointProcessVariableClassification idxBizPvPointProcessVariableClassification = idxBizPvPointProcessVariableClassificationMapper.selectOne(new QueryWrapper<IdxBizPvPointProcessVariableClassification>().eq("INDEX_ADDRESS", pointId).eq("TAG_CODE","分析变量"));
            result = indicatorDataMapper.selectDataByAddressAndtime(idxBizPvPointProcessVariableClassification.getIndexAddress(), startTime, endTime,idxBizPvPointProcessVariableClassification.getGatewayId());
        }
        List<String> seriesData_valuse = new ArrayList<>();
        List<String> axisData_valuse = new ArrayList<>();
        result.forEach(item -> {
            seriesData_valuse.add(item.getValue());
            axisData_valuse.add(item.getCreatedTime().toString());
        });
        resultLast.put("seriesData", seriesData_valuse);
        resultLast.put("axisData", axisData_valuse);
        return resultLast;
    }

    public String getUtcTimeString(String timeStr) {
        SimpleDateFormat dateFormatUTC = new SimpleDateFormat(FORMAT_UTC);
        SimpleDateFormat dateFormatDefault = new SimpleDateFormat(FORMAT_DEFAULT);
        Date time1 = null;
        try {
            time1 = dateFormatDefault.parse(timeStr);
        } catch (ParseException e) {
            logger.info("输入的时间格式错误");
        }
        String s = dateFormatUTC.format(time1);
        return s;
    }

//    @Scheduled(cron = "0 0/5 * * * ?")
    public  void healthWarningMinuteByFJ() {
        Date time = new Date();
        List<IdxBizFanPointProcessVariableClassificationDto> data = idxBizFanPointProcessVariableClassificationMapper.getInfluxDBData();
        Map<String, List<IdxBizFanPointProcessVariableClassificationDto>> maps = data.stream().collect(Collectors.groupingBy(IdxBizFanPointProcessVariableClassificationDto::getGatewayId));
        BoolQueryBuilder boolMustAll = QueryBuilders.boolQuery();
        List<QueryBuilder> should = boolMustAll.should();
        for (String s : maps.keySet()) {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            List<String> address = maps.get(s).stream().map(IdxBizFanPointProcessVariableClassificationDto::getIndexAddress).collect(Collectors.toList());
            boolQueryBuilder.must(QueryBuilders.termsQuery("address.keyword", address)).must(QueryBuilders.matchQuery("gatewayId.keyword", s));
            should.add(boolQueryBuilder);
        }

        // 创建查询构造器
        NativeSearchQueryBuilder queryBuilder = new NativeSearchQueryBuilder()
                //过滤条件
                .withQuery(boolMustAll);
        List<ESEquipments> equipments = new LinkedList<>();
        long totle = 0;
        try {
            SearchHits<ESEquipments> searchHits = elasticsearchTemplate.search(queryBuilder.build(), ESEquipments.class);

            for (SearchHit searchHit : searchHits.getSearchHits()) {
                JSONObject jsonObject = (JSONObject) JSONObject.toJSON(searchHit.getContent());
                ESEquipments eSAlertCalled = JSONObject.toJavaObject(jsonObject, ESEquipments.class);
                equipments.add(eSAlertCalled);
            }
            totle = searchHits.getTotalHits();
        } catch (Exception e) {
            // TODO: handle exception
        }


        for (IdxBizFanPointProcessVariableClassificationDto datum : data) {
            for (ESEquipments equipment : equipments) {
                if (equipment.getAddress().equals(datum.getIndexAddress()) && equipment.getGatewayId().equals(datum.getGatewayId())) {
                    datum.setCurrentValue(equipment.getValueF());
                }
            }
        }

        LambdaQueryWrapper<IdxBizFanPointVarCentralValue> wrapper = new LambdaQueryWrapper<>();
        List<IdxBizFanPointVarCentralValue> idxBizUhefs = idxBizFanPointVarCentralValueMapper.selectList(wrapper);
        List<Map<String, Object>> datas = new ArrayList<>();
        Map<String, Map<String, Object>> resultMap = new HashMap<>();
        for (IdxBizFanPointVarCentralValue idxBizUhef : idxBizUhefs) {
            double value1 = 0.00;
            double value2 = 0.00;
            double value3 = 0.00;
            double value4 = 0.00;
            for (IdxBizFanPointProcessVariableClassificationDto datum : data) {
                if (idxBizUhef.getProcessPoint1Id().equals(datum.getSequenceNbr())) {
                    value1 = datum.getCurrentValue() == null?0.0: datum.getCurrentValue();
                }
                if (idxBizUhef.getProcessPoint2Id().equals(datum.getSequenceNbr())) {
                    value2 = datum.getCurrentValue() == null?0.0: datum.getCurrentValue();
                }
                if (idxBizUhef.getProcessPoint3Id().equals(datum.getSequenceNbr())) {
                    value3 = datum.getCurrentValue() == null?0.0: datum.getCurrentValue();
                }
                if (idxBizUhef.getAnalysisPointId().equals(datum.getSequenceNbr())) {
                    value4 = datum.getCurrentValue() == null?0.0: datum.getCurrentValue();
                }
            }
            Map<String, Object> map = new HashMap<>();
            if (idxBizUhef.getProcess1Min() <= value1 && value1 <= idxBizUhef.getProcess1Max() && idxBizUhef.getProcess2Min() <= value2 && value2 <= idxBizUhef.getPorcess2Max() && idxBizUhef.getProcess3Min() <= value3 && value3 <= idxBizUhef.getProcess3Max()) {
                map.put("analysisVariable", value4);
                map.put("stdDev", idxBizUhef.getAnalysisStdDev());
                map.put("centerValue", idxBizUhef.getAnalysisCenterValue());
                map.put("analysisVariableId", idxBizUhef.getAnalysisPointId());
                resultMap.put(idxBizUhef.getAnalysisPointId(), map);
            }
        }
        Collection<Map<String, Object>> values = resultMap.values();
        if (!values.isEmpty()) {
            logger.info("------------------------------------------开始调用健康指数计算算法开始----------------------------------------");
            HashMap<String, Object> realParams = new HashMap<>();
            realParams.put(gkzxzjskey1, values);
            String response = HttpUtil.createPost(baseUrl + jkzsjsfjurl).body(JSON.toJSONString(realParams)).execute().body();
            JSONObject result = JSON.parseObject(response).getJSONObject("result");
            if (null != result) {
                JSONObject jsonObject = result.getJSONObject("result1");
                List<JSONObject> jsonObjects = JSON.parseArray(JSON.toJSONString(jsonObject.getJSONArray("rows")), JSONObject.class);
                List<String> ids = new ArrayList<>();
                jsonObjects.stream().forEach(e -> ids.add(e.getString("analysisVariableId")));

                LambdaQueryWrapper<IdxBizFanPointProcessVariableClassification> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.in(IdxBizFanPointProcessVariableClassification::getSequenceNbr, ids);
                List<IdxBizFanPointProcessVariableClassification> list = idxBizFanPointProcessVariableClassificationMapper.selectList(queryWrapper);
                List<IdxBizFanHealthIndex> idxBizFanHealthIndexs = new ArrayList<>();
                for (IdxBizFanPointProcessVariableClassification obj : list) {
                    for (JSONObject object : jsonObjects) {
                        if (obj.getSequenceNbr().equals(object.getString("analysisVariableId"))) {
                            IdxBizFanHealthIndex idxBizFanHealthIndex = new IdxBizFanHealthIndex();
                            BeanUtils.copyProperties(obj,idxBizFanHealthIndex );
                            idxBizFanHealthIndex.setHealthIndex(object.getDouble("indexValue"));
                            idxBizFanHealthIndex.setAnalysisObjSeq(obj.getSequenceNbr());
                            idxBizFanHealthIndex.setRecDate(time);
                            idxBizFanHealthIndex.setSequenceNbr(null);
                            idxBizFanHealthIndex.setRecDate(new Date());
                            //获取健康指数对应等级
                            LambdaQueryWrapper<IdxBizFanHealthLevel> query = new LambdaQueryWrapper<>();
                            query.eq(IdxBizFanHealthLevel::getAnalysisObjType, "设备");
                            query.eq(IdxBizFanHealthLevel::getStatus, obj.getStation());
                            query.le(IdxBizFanHealthLevel::getGroupLowerLimit, object.getDouble("indexValue"));
                            query.ge(IdxBizFanHealthLevel::getGroupUpperLimit, object.getDouble("indexValue"));
                            IdxBizFanHealthLevel idxBizFanHealthLevel = idxBizFanHealthLevelMapper.selectOne(query);
                            idxBizFanHealthIndex.setHealthLevel(idxBizFanHealthLevel.getHealthLevel());
                            idxBizFanHealthIndex.setAnalysisType("按时刻");
                            idxBizFanHealthIndex.setAnalysisObjType("测点");
                            idxBizFanHealthIndex.setANOMALY(object.getDouble("scoreValue"));
                            idxBizFanHealthIndexs.add(idxBizFanHealthIndex);
                        }
                    }
                }
                idxBizFanHealthIndexService.saveBatch(idxBizFanHealthIndexs);
            }

            try {
                logger.info("--------------------response： " + response);
                logger.info("------------------------------------------调用健康指数计算算法结束----------------------------------------");
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

//    @Scheduled(cron = "0 0/10 * * * ?")
    public void healthWarningMinuteByGF() {
        Date time = new Date();
        List<IdxBizPvPointProcessVariableClassificationDto> data = idxBizPvPointProcessVariableClassificationMapper.getInfluxDBData();
        Map<String, List<IdxBizPvPointProcessVariableClassificationDto>> maps = data.stream().collect(Collectors.groupingBy(IdxBizPvPointProcessVariableClassificationDto::getGatewayId));
        BoolQueryBuilder boolMustAll = QueryBuilders.boolQuery();
        List<QueryBuilder> should = boolMustAll.should();
        for (String s : maps.keySet()) {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            List<String> address = maps.get(s).stream().map(IdxBizPvPointProcessVariableClassificationDto::getIndexAddress).collect(Collectors.toList());
            boolQueryBuilder.must(QueryBuilders.termsQuery("address.keyword", address)).must(QueryBuilders.matchQuery("gatewayId.keyword", s));
            should.add(boolQueryBuilder);
        }

        // 创建查询构造器
        NativeSearchQueryBuilder queryBuilder = new NativeSearchQueryBuilder()
                //过滤条件
                .withQuery(boolMustAll);
        List<ESEquipments> equipments = new LinkedList<>();
        long totle = 0;
        try {
            SearchHits<ESEquipments> searchHits = elasticsearchTemplate.search(queryBuilder.build(), ESEquipments.class);

            for (SearchHit searchHit : searchHits.getSearchHits()) {
                JSONObject jsonObject = (JSONObject) JSONObject.toJSON(searchHit.getContent());
                ESEquipments eSAlertCalled = JSONObject.toJavaObject(jsonObject, ESEquipments.class);
                equipments.add(eSAlertCalled);
            }
            totle = searchHits.getTotalHits();
        } catch (Exception e) {
            // TODO: handle exception
        }


        for (IdxBizPvPointProcessVariableClassificationDto datum : data) {
            for (ESEquipments equipment : equipments) {
                if (equipment.getAddress().equals(datum.getIndexAddress()) && equipment.getGatewayId().equals(datum.getGatewayId())) {
                    datum.setCurrentValue(equipment.getValueF().doubleValue());
                }
            }
        }

        LambdaQueryWrapper<IdxBizPvPointVarCentralValue> wrapper = new LambdaQueryWrapper<>();
        List<IdxBizPvPointVarCentralValue> idxBizUhefs = idxBizPvPointVarCentralValueMapper.selectList(wrapper);
        Map<String, Map<String, Object>> resultMap = new HashMap<>();
        for (IdxBizPvPointVarCentralValue idxBizUhef : idxBizUhefs) {
            double value1 = 0.00;
            double value2 = 0.00;
            double value3 = 0.00;
            double value4 = 0.00;
            for (IdxBizPvPointProcessVariableClassificationDto datum : data) {
                if (idxBizUhef.getProcessPoint1Id().equals(datum.getSequenceNbr())) {
                    value1 = datum.getCurrentValue();
                }
                if (idxBizUhef.getProcessPoint2Id().equals(datum.getSequenceNbr())) {
                    value2 = datum.getCurrentValue();
                }
                if (idxBizUhef.getProcessPoint3Id().equals(datum.getSequenceNbr())) {
                    value3 = datum.getCurrentValue();
                }
                if (idxBizUhef.getAnalysisPointId().equals(datum.getSequenceNbr())) {
                    value4 = datum.getCurrentValue();
                }
            }
            Map<String, Object> map = new HashMap<>();
            if (idxBizUhef.getProcess1Min() <= value1 && value1 <= idxBizUhef.getProcess1Max() && idxBizUhef.getProcess2Min() <= value2 && value2 <= idxBizUhef.getProcess2Max() && idxBizUhef.getProcess3Min() <= value3 && value3 <= idxBizUhef.getProcess3Max()) {
                map.put("analysisVariable", value4);
                map.put("stdDev", idxBizUhef.getAnalysisStdDev());
                map.put("centerValue", idxBizUhef.getAnalysisCenterValue());
                map.put("analysisVariableId", idxBizUhef.getAnalysisPointId());
                resultMap.put(idxBizUhef.getAnalysisPointId(), map);
            }
        }
        Collection<Map<String, Object>> values = resultMap.values();
        if (!values.isEmpty()) {
            logger.info("------------------------------------------开始调用健康指数计算算法开始----------------------------------------");
            HashMap<String, Object> realParams = new HashMap<>();
            realParams.put(gkzxzjskey1, values);
            String response = HttpUtil.createPost(baseUrl + jkzsgfurl).body(JSON.toJSONString(realParams)).execute().body();
            JSONObject result = JSON.parseObject(response).getJSONObject("result");
            if (null != result) {
                JSONObject jsonObject = result.getJSONObject("result1");
                List<JSONObject> jsonObjects = JSON.parseArray(JSON.toJSONString(jsonObject.getJSONArray("rows")), JSONObject.class);
                List<String> ids = new ArrayList<>();
                jsonObjects.stream().forEach(e -> ids.add(e.getString("analysisVariableId")));

                LambdaQueryWrapper<IdxBizPvPointProcessVariableClassification> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.in(IdxBizPvPointProcessVariableClassification::getSequenceNbr, ids);
                List<IdxBizPvPointProcessVariableClassification> list = idxBizPvPointProcessVariableClassificationMapper.selectList(queryWrapper);
                List<IdxBizPvHealthIndex> idxBizPvHealthIndexs = new ArrayList<>();
                for (IdxBizPvPointProcessVariableClassification obj : list) {
                    for (JSONObject object : jsonObjects) {
                        if (obj.getSequenceNbr().equals(object.getString("analysisVariableId"))) {
                            IdxBizPvHealthIndex idxBizFanHealthIndex = new IdxBizPvHealthIndex();
                            BeanUtils.copyProperties(obj,idxBizFanHealthIndex );
                            idxBizFanHealthIndex.setHealthIndex(object.getDouble("indexValue"));
                            idxBizFanHealthIndex.setAnalysisObjSeq(obj.getSequenceNbr());
                            idxBizFanHealthIndex.setRecDate(time);
                            //获取健康指数对应等级
                            LambdaQueryWrapper<IdxBizPvHealthLevel> query = new LambdaQueryWrapper<>();
                            query.eq(IdxBizPvHealthLevel::getAnalysisObjType, "设备");
                            query.eq(IdxBizPvHealthLevel::getStatus, obj.getStation());
                            query.le(IdxBizPvHealthLevel::getGroupLowerLimit, object.getDouble("indexValue"));
                            query.ge(IdxBizPvHealthLevel::getGroupUpperLimit, object.getDouble("indexValue"));
                            IdxBizPvHealthLevel idxBizFanHealthLevel = idxBizPvHealthLevelMapper.selectOne(query);
                            idxBizFanHealthIndex.setHealthLevel(idxBizFanHealthLevel.getHealthLevel());
                            idxBizFanHealthIndex.setAnalysisType("按时刻");
                            idxBizFanHealthIndex.setAnalysisObjType("测点");
                            idxBizFanHealthIndex.setANOMALY(object.getDouble("scoreValue"));
                            idxBizPvHealthIndexs.add(idxBizFanHealthIndex);
                        }
                    }
                }
                idxBizPvHealthIndexService.saveBatch(idxBizPvHealthIndexs);
            }

            try {
                logger.info("--------------------response： " + response);
                logger.info("------------------------------------------调用健康指数计算算法结束----------------------------------------");
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /**
     * 根据查询条件获取列表信息
     *
     * @param mustQuerCondtion
     * @param shouldQuerCondtion
     * @param tClass
     * @param <T>
     * @return
     */
    public <T> List<T> getListDataByCondtions(Map<String, List<String>> mustQuerCondtion, Map<String, String> shouldQuerCondtion, Class<T> tClass) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (!ObjectUtils.isEmpty(mustQuerCondtion)) {
            for (String key : mustQuerCondtion.keySet()) {
                List<String> va = mustQuerCondtion.get(key);
                queryBuilder.must(QueryBuilders.termsQuery(key, va));
            }
        }
        if (!ObjectUtils.isEmpty(shouldQuerCondtion)) {
            for (String key : shouldQuerCondtion.keySet()) {
                queryBuilder.should(QueryBuilders.wildcardQuery(key, shouldQuerCondtion.get(key)));
            }
        }
        Query query = new NativeSearchQueryBuilder()
                .withQuery(queryBuilder)
                .build();
        query.setTrackTotalHits(true);
        SearchHits search = elasticsearchTemplate.search(query, tClass);
        if (search.hasSearchHits()) {
            List<SearchHit<T>> searchHitList = search.getSearchHits();
            List<T> list = searchHitList.stream().map(hit -> hit.getContent()).collect(Collectors.toList());
            return list;
        }
        return null;
    }


    public Map<String, String> getUnitByIndexAddress(String stationType, String pointId) {
        IndicatorData indicatorData = new IndicatorData();
        if ("FD".equals(stationType)) {
            IdxBizFanPointProcessVariableClassification indexAddress = idxBizFanPointProcessVariableClassificationMapper.selectOne(new QueryWrapper<IdxBizFanPointProcessVariableClassification>().eq("INDEX_ADDRESS", pointId));
            indicatorData = indicatorDataMapper.selectUnitByAddressAndGatewayId(indexAddress.getIndexAddress(), indexAddress.getGatewayId());
        } else {
            IdxBizPvPointProcessVariableClassification indexAddress = idxBizPvPointProcessVariableClassificationMapper.selectOne(new QueryWrapper<IdxBizPvPointProcessVariableClassification>().eq("INDEX_ADDRESS", pointId));
            indicatorData = indicatorDataMapper.selectUnitByAddressAndGatewayId(indexAddress.getIndexAddress(), indexAddress.getGatewayId());
        }
        HashMap<String, String> resultMap = new HashMap<>();
        resultMap.put("title", indicatorData.getUnit());
        return resultMap;
    }









    private static final BlockingQueue<IdxBizFanPointProcessVariableClassification> fifo = new LinkedBlockingQueue<>(5000);



    private static int threadNumber = Runtime.getRuntime().availableProcessors() * 2;



    public void chuli() throws InterruptedException {

        this.getFanConditionVariablesByTimeAnalyseNew(null, null);
        // 借助Executors
        ExecutorService service = Executors.newCachedThreadPool();
        for (int i = 0; i < threadNumber; i++) {
            Consumer consumer = new Consumer(fifo, this);
            service.execute(consumer);
        }
        Thread.sleep(200000);
        // 退出Executor
        service.shutdown();
    }



    public void info(String gatewayId, String startTime, String endTime, IdxBizFanPointProcessVariableClassification idxBizFanPointProcessVariableClassification){
        logger.info("异步执行,gatewayId:{},分析Id:{}", gatewayId, idxBizFanPointProcessVariableClassification.getSequenceNbr());
        List<IdxBizFanPointVarCorrelation> gongkuangList = idxBizFanPointVarCorrelationMapper.selectList(new QueryWrapper<IdxBizFanPointVarCorrelation>().eq("ANALYSIS_GATEWAY_ID", idxBizFanPointProcessVariableClassification.getGatewayId()).eq("ANALYSIS_POINT_ID", idxBizFanPointProcessVariableClassification.getSequenceNbr()));
        if (gongkuangList.size() > 0) {
            foreachHandlerConditionVariabAnalyseFanNew(gatewayId, gongkuangList, startTime, endTime, idxBizFanPointProcessVariableClassification);
        }
    }

    //遍历处理数据-组装风机
    public void foreachHandlerConditionVariabAnalyseFanNew(String tableName, List<IdxBizFanPointVarCorrelation> list, String startTime, String endTime, IdxBizFanPointProcessVariableClassification idxBizFanPointProcessVariableClassification) {
        List<IndicatorData> returnList = indicatorDataMapper.selectDataByAddressAndtime(idxBizFanPointProcessVariableClassification.getIndexAddress(), startTime, endTime,tableName);
        List<Double> data1 = returnList.stream().map(t -> Double.parseDouble(t.getValue())).collect(Collectors.toList());
        list.forEach(idxBizFanPointVarCorrelation -> {
            logger.info("---------------------------------风机相关性-----------开始查询influxdb--------------------------------");
            List<IndicatorData> returnList1 = indicatorDataMapper.selectDataByAddressAndtime(idxBizFanPointVarCorrelation.getProcessIndexAddress(), startTime, endTime,tableName);
            List<Double> data2 = returnList1.stream().map(t -> Double.parseDouble(t.getValue())).collect(Collectors.toList());
            HashMap<String, Object> map1 = new HashMap<>();
            map1.put("data1", data1);
            map1.put("data2", data2);
            if (!map1.isEmpty()) {
                logger.info("------------------------------风机相关性------------分析变量与工况变量相关性分析算法开始----------------------------------------");
                logger.info("------------------------------风机相关性------------分析变量与工况变量相关性分析算参数---------------------------------------" + JSON.toJSONString(map1));
                String response = HttpUtil.createPost(baseUrlXGX).body(JSON.toJSONString(map1)).execute().body();
                if (response.contains("correlation")) {
                    JSONObject jsonObject = JSONObject.parseObject(response);
                    idxBizFanPointVarCorrelation.setCorrelationCoefficient(jsonObject.getDoubleValue("correlation"));
                    logger.info("------------------------------------------风机相关性：：相关性更新业务表成功----------------------------------------");
                } else {
                    idxBizFanPointVarCorrelation.setCorrelationCoefficient(0.0);
                }
                idxBizFanPointVarCorrelation.setRecDate(new Date());
                idxBizFanPointVarCorrelationMapper.updateById(idxBizFanPointVarCorrelation);
                logger.info("----------------------------风机相关性--------------分析变量与工况变量相关性分析算法结束----------------------------------------");
            } else {
                idxBizFanPointVarCorrelation.setCorrelationCoefficient(0.0);
                idxBizFanPointVarCorrelation.setRecDate(new Date());
                idxBizFanPointVarCorrelationMapper.updateById(idxBizFanPointVarCorrelation);
            }
        });
    }

    //相关性分析-风机入口
    public void getFanConditionVariablesByTimeAnalyseNew(String startTime, String endTime) {
        try {
            HashMap<String, List<IdxBizFanPointProcessVariableClassification>> idxBizFanPointProcessVariableClassificationHashMap = getIdxBizFanPointProcessVariableClassificationListOfAnaLyse();
            idxBizFanPointProcessVariableClassificationHashMap.keySet().forEach(s -> {
                List<IdxBizFanPointProcessVariableClassification> list = idxBizFanPointProcessVariableClassificationHashMap.get(s);
                fifo.addAll(list);
            });
            cacheExecInfo.remove(SmartAnalyseEnum.FAN_XGX.getKey());
        } catch (Exception exception) {
            cacheExecInfo.remove(SmartAnalyseEnum.PV_XGX.getKey());
        }
    }







    /**
     * 以下为相关性-光伏-方法
     */
    private static final BlockingQueue<IdxBizPvPointProcessVariableClassification> fifoPv = new LinkedBlockingQueue<>(5000);

    public void chuliPv(String startTime, String endTime) throws InterruptedException {

        this.getPvConditionVariablesByTimeAnalyseNew();
        // 借助Executors
        ExecutorService service = Executors.newCachedThreadPool();
        for (int i = 0; i < threadNumber; i++) {
            ConsumerPv consumer = new ConsumerPv(fifoPv, this, startTime, endTime);
            service.execute(consumer);
        }
        Thread.sleep(200000);
        // 退出Executor
        service.shutdown();
    }

    public void infoPv(String gatewayId, String startTime, String endTime, IdxBizPvPointProcessVariableClassification idxBizPvPointProcessVariableClassification){
        logger.info("异步执行,gatewayId:{},分析Id:{}", gatewayId, idxBizPvPointProcessVariableClassification.getSequenceNbr());
        List<IdxBizPvPointVarCorrelation> gongkuangList = idxBizPvPointVarCorrelationMapper.selectList(new QueryWrapper<IdxBizPvPointVarCorrelation>().eq("ANALYSIS_GATEWAY_ID", idxBizPvPointProcessVariableClassification.getGatewayId()).eq("ANALYSIS_POINT_ID", idxBizPvPointProcessVariableClassification.getSequenceNbr()));
        if (gongkuangList.size() > 0) {
            foreachHandlerConditionVariabAnalysePvNew(gatewayId, gongkuangList, startTime, endTime, idxBizPvPointProcessVariableClassification);
        }
    }

    //遍历处理数据-组装风机
    public void foreachHandlerConditionVariabAnalysePvNew(String tableName, List<IdxBizPvPointVarCorrelation> list, String startTime, String endTime, IdxBizPvPointProcessVariableClassification idxBizPvPointProcessVariableClassification) {
        List<IndicatorData> returnList = indicatorDataMapper.selectDataByAddressAndtime(idxBizPvPointProcessVariableClassification.getIndexAddress(), startTime, endTime,tableName);
        List<Double> data1 = returnList.stream().map(t -> Double.parseDouble(t.getValue())).collect(Collectors.toList());
        list.forEach(idxBizPvPointVarCorrelation -> {
            logger.info("---------------------------------风机相关性-----------开始查询influxdb--------------------------------");
            List<IndicatorData> returnList1 = indicatorDataMapper.selectDataByAddressAndtime(idxBizPvPointVarCorrelation.getProcessIndexAddress(), startTime, endTime,tableName);
            List<Double> data2 = returnList1.stream().map(t -> Double.parseDouble(t.getValue())).collect(Collectors.toList());
            HashMap<String, Object> map1 = new HashMap<>();
            map1.put("data1", data1);
            map1.put("data2", data2);
            if (!map1.isEmpty()) {
                logger.info("------------------------------风机相关性------------分析变量与工况变量相关性分析算法开始----------------------------------------");
                logger.info("------------------------------风机相关性------------分析变量与工况变量相关性分析算参数---------------------------------------" + JSON.toJSONString(map1));
                String response = HttpUtil.createPost(baseUrlXGX).body(JSON.toJSONString(map1)).execute().body();
                if (response.contains("correlation")) {
                    JSONObject jsonObject = JSONObject.parseObject(response);
                    idxBizPvPointVarCorrelation.setCorrelationCoefficient(jsonObject.getDoubleValue("correlation"));
                    logger.info("------------------------------------------风机相关性：：相关性更新业务表成功----------------------------------------");
                } else {
                    idxBizPvPointVarCorrelation.setCorrelationCoefficient(0.0);
                }
                idxBizPvPointVarCorrelation.setRecDate(new Date());
                idxBizPvPointVarCorrelationMapper.updateById(idxBizPvPointVarCorrelation);
                logger.info("----------------------------风机相关性--------------分析变量与工况变量相关性分析算法结束----------------------------------------");
            } else {
                idxBizPvPointVarCorrelation.setCorrelationCoefficient(0.0);
                idxBizPvPointVarCorrelation.setRecDate(new Date());
                idxBizPvPointVarCorrelationMapper.updateById(idxBizPvPointVarCorrelation);
            }
        });
    }
    //相关性分析-光伏
    public void getPvConditionVariablesByTimeAnalyseNew() {
        try {
            HashMap<String, List<IdxBizFanPointProcessVariableClassification>> idxBizFanPointProcessVariableClassificationHashMap = getIdxBizFanPointProcessVariableClassificationListOfAnaLyse();
            idxBizFanPointProcessVariableClassificationHashMap.keySet().forEach(s -> {
                List<IdxBizFanPointProcessVariableClassification> list = idxBizFanPointProcessVariableClassificationHashMap.get(s);
                fifo.addAll(list);
            });
            cacheExecInfo.remove(SmartAnalyseEnum.FAN_XGX.getKey());
        } catch (Exception exception) {
            cacheExecInfo.remove(SmartAnalyseEnum.PV_XGX.getKey());
        }
    }


    @Scheduled(cron = "0 0/10 * * * ?")
    @Async("async")
    public void healthWarningMinuteByFan() {
        if (!openHealth){
            return;
        }
        Date time = new Date();
        Calendar calendar = Calendar.getInstance();
        List<IdxBizFanPointProcessVariableClassificationDto> data = idxBizFanPointProcessVariableClassificationMapper.getInfluxDBData();
        Map<String, List<IdxBizFanPointProcessVariableClassificationDto>> maps = data.stream().collect(Collectors.groupingBy(IdxBizFanPointProcessVariableClassificationDto::getGatewayId));
        BoolQueryBuilder boolMustAll = QueryBuilders.boolQuery();
        List<QueryBuilder> should = boolMustAll.should();
        for (String s : maps.keySet()) {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            List<String> address = maps.get(s).stream().map(IdxBizFanPointProcessVariableClassificationDto::getIndexAddress).collect(Collectors.toList());
            boolQueryBuilder.must(QueryBuilders.termsQuery("address.keyword", address)).must(QueryBuilders.matchQuery("gatewayId.keyword", s));
            should.add(boolQueryBuilder);
        }

        // 创建查询构造器
        NativeSearchQueryBuilder queryBuilder = new NativeSearchQueryBuilder()
                //过滤条件
                .withQuery(boolMustAll);
        List<ESEquipments> equipments = new LinkedList<>();
        long totle = 0;
        try {
            SearchHits<ESEquipments> searchHits = elasticsearchTemplate.search(queryBuilder.build(), ESEquipments.class);

            for (SearchHit searchHit : searchHits.getSearchHits()) {
                JSONObject jsonObject = (JSONObject) JSONObject.toJSON(searchHit.getContent());
                ESEquipments eSAlertCalled = JSONObject.toJavaObject(jsonObject, ESEquipments.class);
                equipments.add(eSAlertCalled);
            }
            totle = searchHits.getTotalHits();
        } catch (Exception e) {
            // TODO: handle exception
        }


        for (IdxBizFanPointProcessVariableClassificationDto datum : data) {
            for (ESEquipments equipment : equipments) {
                if (equipment.getAddress().equals(datum.getIndexAddress()) && equipment.getGatewayId().equals(datum.getGatewayId())) {
                    datum.setCurrentValue(equipment.getValueF());
                }
            }
        }

        LambdaQueryWrapper<IdxBizFanPointVarCentralValue> wrapper = new LambdaQueryWrapper<>();
        List<IdxBizFanPointVarCentralValue> idxBizUhefs = idxBizFanPointVarCentralValueMapper.selectList(wrapper);
        HashMap<String, Object> requestMap = new HashMap<>();
        ArrayList<Object> analysisVariableList = new ArrayList<>();
        ArrayList<Object> stdDevList = new ArrayList<>();
        ArrayList<Object> centerValueList = new ArrayList<>();
        ArrayList<Object> analysisVariableIdList = new ArrayList<>();
        for (IdxBizFanPointVarCentralValue idxBizUhef : idxBizUhefs) {
            double value1 = 0.00;
            double value2 = 0.00;
            double value3 = 0.00;
            double value4 = 0.00;
            for (IdxBizFanPointProcessVariableClassificationDto datum : data) {
                if (idxBizUhef.getProcessPoint1Id().equals(datum.getSequenceNbr())) {
                    value1 = datum.getCurrentValue() == null ? 0.0 : datum.getCurrentValue();
                }
                if (idxBizUhef.getProcessPoint2Id().equals(datum.getSequenceNbr())) {
                    value2 = datum.getCurrentValue() == null ? 0.0 : datum.getCurrentValue();
                }
                if (idxBizUhef.getProcessPoint3Id().equals(datum.getSequenceNbr())) {
                    value3 = datum.getCurrentValue() == null ? 0.0 : datum.getCurrentValue();
                }
                if (idxBizUhef.getAnalysisPointId().equals(datum.getSequenceNbr())) {
                    value4 = datum.getCurrentValue() == null ? 0.0 : datum.getCurrentValue();
                }
            }


            if ((null == idxBizUhef.getProcess1Min() || idxBizUhef.getProcess1Min() <= value1 ) && (null == idxBizUhef.getProcess1Max()||value1 <= idxBizUhef.getProcess1Max()  )
                    &&(null == idxBizUhef.getProcess2Min() || idxBizUhef.getProcess2Min() <= value2 ) && (null == idxBizUhef.getPorcess2Max() || value2 <= idxBizUhef.getPorcess2Max())
                    &&(null == idxBizUhef.getProcess3Min() || idxBizUhef.getProcess3Min() <= value3 )  && (null ==idxBizUhef.getProcess3Max() || value3 <= idxBizUhef.getProcess3Max())) {
              if (!analysisVariableIdList.contains(idxBizUhef.getAnalysisPointId())){
                  analysisVariableList.add(value4);
                  stdDevList.add(idxBizUhef.getAnalysisStdDev());
                  centerValueList.add(idxBizUhef.getAnalysisCenterValue());
                  analysisVariableIdList.add(idxBizUhef.getAnalysisPointId());
              }
            }
        }

        requestMap.put("analysisVariable", analysisVariableList);
        requestMap.put("stdDev", stdDevList);
        requestMap.put("centerValue", centerValueList);
        requestMap.put("analysisVariableId", analysisVariableIdList);

        logger.info("------------------------------------------开始调用健康指数计算算法开始----------------------------------------");

        String response = HttpUtil.createPost(baseUrlZSFX).body(JSON.toJSONString(requestMap)).execute().body();

        JSONObject jsonObject = JSON.parseObject(response);
        if (jsonObject.containsKey("indexValue")) {
            JSONArray indexValueArray = jsonObject.getJSONArray("indexValue");
            JSONArray scoreValueArray = jsonObject.getJSONArray("scoreValue");
            JSONArray analysisVariableIdArray = jsonObject.getJSONArray("analysisVariableId");
            List<String> jsonArrayToStringList = JSONObject.parseArray(analysisVariableIdArray.toJSONString(),String.class);
            LambdaQueryWrapper<IdxBizFanPointProcessVariableClassification> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.in(IdxBizFanPointProcessVariableClassification::getSequenceNbr, jsonArrayToStringList);
            List<IdxBizFanPointProcessVariableClassification> list = idxBizFanPointProcessVariableClassificationMapper.selectList(queryWrapper);
            List<IdxBizFanHealthIndex> idxBizFanHealthIndexs = new ArrayList<>();

            Set<String> stations = list.stream().map(IdxBizFanPointProcessVariableClassification::getStation).collect(Collectors.toSet());

            LambdaQueryWrapper<IdxBizFanHealthLevel> query = new LambdaQueryWrapper<>();
            query.eq(IdxBizFanHealthLevel::getAnalysisObjType, "测点");
            query.in(IdxBizFanHealthLevel::getStatus, stations);
            List<IdxBizFanHealthLevel> idxBizFanHealthLevels = idxBizFanHealthLevelMapper.selectList(query);

            for (IdxBizFanPointProcessVariableClassification obj : list) {
                for (int i = 0; i < analysisVariableIdArray.size(); i++) {
                    if (analysisVariableIdArray.get(i).toString().equals(obj.getSequenceNbr())){
                        IdxBizFanHealthIndex idxBizFanHealthIndex = new IdxBizFanHealthIndex();
                        BeanUtils.copyProperties(obj, idxBizFanHealthIndex,"sequenceNbr");
                        idxBizFanHealthIndex.setHealthIndex(indexValueArray.getDoubleValue(i)< 0 ? 0 : indexValueArray.getDoubleValue(i));
                        idxBizFanHealthIndex.setAnalysisObjSeq(obj.getSequenceNbr());
                        idxBizFanHealthIndex.setRecDate(time);
                      //  idxBizFanHealthIndex.setSequenceNbr(null);
                        idxBizFanHealthIndex.setWeigth(1.0);
                        //获取健康指数对应等级
                        for (IdxBizFanHealthLevel idxBizFanHealthLevel : idxBizFanHealthLevels) {
                            if (indexValueArray.getDoubleValue(i) <= idxBizFanHealthLevel.getGroupUpperLimit()
                                    && indexValueArray.getDoubleValue(i) >= idxBizFanHealthLevel.getGroupLowerLimit()){
                                idxBizFanHealthIndex.setHealthLevel(idxBizFanHealthLevel.getHealthLevel());

                            }
                        }
                        idxBizFanHealthIndex.setAnalysisType("按时刻");
                        idxBizFanHealthIndex.setAnalysisObjType("测点");
                        if (ObjectUtils.isEmpty(scoreValueArray.getDoubleValue(i))){
                            System.out.println(JSON.toJSONString(requestMap));
                            idxBizFanHealthIndex.setANOMALY(0.0);

                        }else {
                            idxBizFanHealthIndex.setANOMALY(scoreValueArray.getDoubleValue(i));

                        }
                        idxBizFanHealthIndex.setANALYSISTIME(DateUtils.getDateNowString());
                        idxBizFanHealthIndexs.add(idxBizFanHealthIndex);
                    }
                }
            }
            idxBizFanHealthIndexService.saveBatch(idxBizFanHealthIndexs);
        }

        try {
            logger.info("--------------------response： " + response);
            logger.info("------------------------------------------调用健康指数计算算法结束----------------------------------------");
            logger.info("------------------------------------------开始计算预警----------------------------------------");

            healthStatusIndicatorService.healthWarningMinute(calendar,time);

        } catch (Exception e) {
            throw new RuntimeException(e);
        }

    }


    @Scheduled(cron = "0 0/10 * * * ?")
    @Async("async")
    public void healthWarningMinuteByPv() {
        if (!openHealth){
            return;
        }
        Calendar calendar = Calendar.getInstance();
        Date time = new Date();
        List<IdxBizPvPointProcessVariableClassificationDto> data = idxBizPvPointProcessVariableClassificationMapper.getInfluxDBData();
        Map<String, List<IdxBizPvPointProcessVariableClassificationDto>> maps = data.stream().collect(Collectors.groupingBy(IdxBizPvPointProcessVariableClassificationDto::getGatewayId));
        BoolQueryBuilder boolMustAll = QueryBuilders.boolQuery();
        List<QueryBuilder> should = boolMustAll.should();
        for (String s : maps.keySet()) {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            List<String> address = maps.get(s).stream().map(IdxBizPvPointProcessVariableClassificationDto::getIndexAddress).collect(Collectors.toList());
            boolQueryBuilder.must(QueryBuilders.termsQuery("address.keyword", address)).must(QueryBuilders.matchQuery("gatewayId.keyword", s));
            should.add(boolQueryBuilder);
        }
        // 创建查询构造器
        NativeSearchQueryBuilder queryBuilder = new NativeSearchQueryBuilder()
                //过滤条件
                .withQuery(boolMustAll);
        List<ESEquipments> equipments = new LinkedList<>();
        long totle = 0;
        try {
            SearchHits<ESEquipments> searchHits = elasticsearchTemplate.search(queryBuilder.build(), ESEquipments.class);

            for (SearchHit searchHit : searchHits.getSearchHits()) {
                JSONObject jsonObject = (JSONObject) JSONObject.toJSON(searchHit.getContent());
                ESEquipments eSAlertCalled = JSONObject.toJavaObject(jsonObject, ESEquipments.class);
                equipments.add(eSAlertCalled);
            }
            totle = searchHits.getTotalHits();
        } catch (Exception e) {
            // TODO: handle exception
        }
        for (IdxBizPvPointProcessVariableClassificationDto datum : data) {
            for (ESEquipments equipment : equipments) {
                if (equipment.getAddress().equals(datum.getIndexAddress()) && equipment.getGatewayId().equals(datum.getGatewayId())) {
                    datum.setCurrentValue(equipment.getValueF().doubleValue());
                }
            }
        }
        LambdaQueryWrapper<IdxBizPvPointVarCentralValue> wrapper = new LambdaQueryWrapper<>();
        List<IdxBizPvPointVarCentralValue> idxBizUhefs = idxBizPvPointVarCentralValueMapper.selectList(wrapper);
        HashMap<String, Object> requestMap = new HashMap<>();
        ArrayList<Object> analysisVariableList = new ArrayList<>();
        ArrayList<Object> stdDevList = new ArrayList<>();
        ArrayList<Object> centerValueList = new ArrayList<>();
        ArrayList<Object> analysisVariableIdList = new ArrayList<>();
        for (IdxBizPvPointVarCentralValue idxBizUhef : idxBizUhefs) {
            double value1 = 0.00;
            double value2 = 0.00;
            double value3 = 0.00;
            double value4 = 0.00;
            for (IdxBizPvPointProcessVariableClassificationDto datum : data) {
                if (idxBizUhef.getProcessPoint1Id().equals(datum.getSequenceNbr())) {
                    value1 = datum.getCurrentValue();
                }
                if (idxBizUhef.getProcessPoint2Id().equals(datum.getSequenceNbr())) {
                    value2 = datum.getCurrentValue();
                }
                if (idxBizUhef.getProcessPoint3Id().equals(datum.getSequenceNbr())) {
                    value3 = datum.getCurrentValue();
                }
                if (idxBizUhef.getAnalysisPointId().equals(datum.getSequenceNbr())) {
                    value4 = datum.getCurrentValue();
                }
            }
            if ((null == idxBizUhef.getProcess1Min() || idxBizUhef.getProcess1Min() <= value1 ) && (null == idxBizUhef.getProcess1Max()||value1 <= idxBizUhef.getProcess1Max()  )
                    &&(null == idxBizUhef.getProcess2Min() || idxBizUhef.getProcess2Min() <= value2 ) && (null == idxBizUhef.getProcess2Max() || value2 <= idxBizUhef.getProcess2Max())
                    &&(null == idxBizUhef.getProcess3Min() || idxBizUhef.getProcess3Min() <= value3 )  && (null ==idxBizUhef.getProcess3Max() || value3 <= idxBizUhef.getProcess3Max())) {
               if (!analysisVariableIdList.contains(idxBizUhef.getAnalysisPointId())){
                   analysisVariableList.add(value4);
                   stdDevList.add(idxBizUhef.getAnalysisStdDev());
                   centerValueList.add(idxBizUhef.getAnalysisCenterValue());
                   analysisVariableIdList.add(idxBizUhef.getAnalysisPointId());
               }
            }
        }
        requestMap.put("analysisVariable", analysisVariableList);
        requestMap.put("stdDev", stdDevList);
        requestMap.put("centerValue", centerValueList);
        requestMap.put("analysisVariableId", analysisVariableIdList);
        logger.info("------------------------------------------开始调用健康指数计算算法开始----------------------------------------");
        String response = HttpUtil.createPost(baseUrlZSFX).body(JSON.toJSONString(requestMap)).execute().body();
        JSONObject jsonObject = JSON.parseObject(response);
        if (jsonObject.containsKey("indexValue")) {
            JSONArray indexValueArray = jsonObject.getJSONArray("indexValue");
            JSONArray scoreValueArray = jsonObject.getJSONArray("scoreValue");
            JSONArray analysisVariableIdArray = jsonObject.getJSONArray("analysisVariableId");
            List<String> jsonArrayToStringList = JSONObject.parseArray(analysisVariableIdArray.toJSONString(),String.class);
            LambdaQueryWrapper<IdxBizPvPointProcessVariableClassification> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.in(IdxBizPvPointProcessVariableClassification::getSequenceNbr, jsonArrayToStringList);
            List<IdxBizPvPointProcessVariableClassification> list = idxBizPvPointProcessVariableClassificationMapper.selectList(queryWrapper);

            Set<String> stations = list.stream().map(IdxBizPvPointProcessVariableClassification::getStation).collect(Collectors.toSet());

            LambdaQueryWrapper<IdxBizPvHealthLevel> query = new LambdaQueryWrapper<>();
            query.eq(IdxBizPvHealthLevel::getAnalysisObjType, "测点");
            query.in(IdxBizPvHealthLevel::getStatus, stations);
            List<IdxBizPvHealthLevel> idxBizFanHealthLevels = idxBizPvHealthLevelMapper.selectList(query);


            List<IdxBizPvHealthIndex> idxBizPvHealthIndexs = new ArrayList<>();
            for (IdxBizPvPointProcessVariableClassification obj : list) {
                for (int i = 0; i < analysisVariableIdArray.size(); i++) {
                    if (analysisVariableIdArray.get(i).toString().equals(obj.getSequenceNbr())){
                        IdxBizPvHealthIndex idxBizPvHealthIndex = new IdxBizPvHealthIndex();
                        BeanUtils.copyProperties(obj, idxBizPvHealthIndex, "sequenceNbr");
                 //       idxBizPvHealthIndex.setSequenceNbr(null);
                        idxBizPvHealthIndex.setHealthIndex(indexValueArray.getDoubleValue(i)< 0 ? 0 : indexValueArray.getDoubleValue(i));
                        idxBizPvHealthIndex.setAnalysisObjSeq(obj.getSequenceNbr());
                        idxBizPvHealthIndex.setRecDate(time);
                        idxBizPvHealthIndex.setWeigth(1.0);
                        //获取健康指数对应等级

                        for (IdxBizPvHealthLevel idxBizFanHealthLevel : idxBizFanHealthLevels) {
                            if (indexValueArray.getDoubleValue(i) <= idxBizFanHealthLevel.getGroupUpperLimit()
                                    && indexValueArray.getDoubleValue(i) >= idxBizFanHealthLevel.getGroupLowerLimit()){
                                idxBizPvHealthIndex.setHealthLevel(idxBizFanHealthLevel.getHealthLevel());

                            }
                        }
                        idxBizPvHealthIndex.setAnalysisType("按时刻");
                        idxBizPvHealthIndex.setAnalysisObjType("测点");
                        idxBizPvHealthIndex.setANOMALY(scoreValueArray.getDoubleValue(i));
                        idxBizPvHealthIndex.setANALYSISTIME(DateUtils.getDateNowString());
                        idxBizPvHealthIndexs.add(idxBizPvHealthIndex);
                    }
                }
            }
            idxBizPvHealthIndexService.saveBatch(idxBizPvHealthIndexs);
        }
        try {
            logger.info("--------------------response： " + response);
            logger.info("------------------------------------------调用健康指数计算算法结束----------------------------------------");
        } catch (Exception e) {
            throw new RuntimeException(e);
        }

        healthStatusIndicatorService.healthWarningMinuteGF(calendar,time);
    }


}
