package com.yeejoin.amos.api.householdapi.controller;

import com.yeejoin.amos.api.householdapi.Utils.GolangRequestUtil;
import com.yeejoin.amos.api.householdapi.Utils.HouseholdPvUtils;
import com.yeejoin.amos.api.householdapi.constant.GoLangConstant;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.GolangStationList;
import com.yeejoin.amos.api.householdapi.face.service.GoLangDataAcquisitionService;
import fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.io.IOException;
import java.util.HashMap;


/**
 * 户用光伏-厂商API haders
 *
 * @author system_generator
 * @date 2023-06-07
 */
@RestController
@Api(tags = "测试")
@RequestMapping(value = "/household-pv-api-test1")
public class HouseholdTestController {
    @Autowired
    private HouseholdPvUtils householdPvUtils;
    @Autowired
   private GoLangDataAcquisitionService goLangDataAcquisitionService;


    /**
     * 新增户用光伏-厂商API haders
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/gdwdemo")
    @ApiOperation(httpMethod = "POST", value = "固德威示例", notes = "固德威示例")
    public String save(Long seq) throws IOException {
        return householdPvUtils.gerResponseByAPiID(seq);
    }
    /**
     * 新增户用光伏-厂商API haders
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/golangnew")
    @ApiOperation(httpMethod = "POST", value = "锦浪云", notes = "锦浪云")
    public void golangnew() throws IOException {
//        goLangDataAcquisitionService.stationList();
//          goLangDataAcquisitionService.stationDetail();
//        goLangDataAcquisitionService.collectorList();
////        goLangDataAcquisitionService.inverterList();
        goLangDataAcquisitionService.collectorDetail();
        goLangDataAcquisitionService.inverterDetail();
//        goLangDataAcquisitionService.inverAlramInfo();
    }
}
