package com.yeejoin.amos.boot.module.jcs.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.PowerrTransferLogServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerrTransferLogDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 力量调派发送信息记录表
 *
 * @author litw
 * @date 2021-11-05
 */
@RestController
@Api(tags = "力量调派发送信息记录表Api")
@RequestMapping(value = "/powerr-transfer-log")
public class PowerrTransferLogController extends BaseController {

    @Autowired
    PowerrTransferLogServiceImpl powerrTransferLogServiceImpl;

    /**
     * 新增力量调派发送信息记录表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增力量调派发送信息记录表", notes = "新增力量调派发送信息记录表")
	public ResponseModel<PowerrTransferLogDto> save(@RequestBody PowerrTransferLogDto model) {
	    model = powerrTransferLogServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新力量调派发送信息记录表", notes = "根据sequenceNbr更新力量调派发送信息记录表")
	public ResponseModel<PowerrTransferLogDto> updateBySequenceNbrPowerrTransferLog(@RequestBody PowerrTransferLogDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(powerrTransferLogServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除力量调派发送信息记录表", notes = "根据sequenceNbr删除力量调派发送信息记录表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(powerrTransferLogServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个力量调派发送信息记录表",  notes = "根据sequenceNbr查询单个力量调派发送信息记录表")
	public ResponseModel<PowerrTransferLogDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(powerrTransferLogServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
	 * 根据id,type查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/selectOneDetails")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个力量调派发送信息记录表",  notes = "根据sequenceNbr查询单个力量调派发送信息记录表")
	public ResponseModel<PowerrTransferLogDto> selectOneDetails(Long id, String type) {
		return ResponseHelper.buildResponse(powerrTransferLogServiceImpl.selectOneDetails(id,type));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "力量调派发送信息记录表分页查询",  notes = "力量调派发送信息记录表分页查询")
	public ResponseModel<Page<PowerrTransferLogDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<PowerrTransferLogDto> page = new Page<PowerrTransferLogDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(powerrTransferLogServiceImpl.queryForPowerrTransferLogPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "力量调派发送信息记录表列表全部数据查询",   notes = "力量调派发送信息记录表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<PowerrTransferLogDto>> selectForList() {
	    return ResponseHelper.buildResponse(powerrTransferLogServiceImpl.queryForPowerrTransferLogList());
	}
}
