package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 户用光伏监盘逆变器电能表
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_jp_inverter_electricity")
public class JpInverterElectricity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 逆变器id
     */
	@TableField("inverter_id")
    private Long inverterId;

    /**
     * sn编码
     */
	@TableField("sn_code")
    private String snCode;

    /**
     * 电能名称
     */
	@TableField("name")
    private String name;

    /**
     * 电能类型(直流/交流)
     */
	@TableField("type")
    private String type;

    /**
     * 电压
     */
	@TableField("voltage")
    private Double voltage;

    /**
     * 电流
     */
	@TableField("current")
    private Double current;

    /**
     * 功率
     */
	@TableField("power")
    private Double power;

    /**
     * 频率
     */
	@TableField("frequency")
    private Double frequency;

    /**
     * 第三方电站id
     */
	@TableField("third_station_id")
    private String thirdStationId;

    /**
     * 第三方厂商标识
     */
	@TableField("third_code")
    private String thirdCode;

}
