package com.yeejoin.amos.boot.module.hygf.biz.scheduled;

import com.yeejoin.amos.boot.module.hygf.biz.service.impl.JpStationServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

import com.yeejoin.amos.boot.module.hygf.biz.service.impl.MonthPowerServiceImpl;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.TdHygfJpCollectorHistoryServiceImpl;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.TdHygfJpInvertorElecHistoryServiceImpl;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/9/21
 */
@EnableScheduling
public class WindSpeedScheduled {

	@Autowired
    JpStationServiceImpl jpStationServiceImpl;

	@Autowired
	TdHygfJpCollectorHistoryServiceImpl tdHygfJpCollectorHistoryServiceImpl;

	@Autowired
	TdHygfJpInvertorElecHistoryServiceImpl tdHygfJpInvertorElecHistoryServiceImpl;

	@Scheduled(cron = "${cheduled.crons}")
	private void initData() {
        jpStationServiceImpl.getMonthPower();
		tdHygfJpCollectorHistoryServiceImpl.syncData();
		tdHygfJpInvertorElecHistoryServiceImpl.syncData();
	}
}
