package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yeejoin.amos.boot.module.hygf.api.dto.ReviewDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.TdHygfJpInverterWarnDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpCollector;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpStation;
import com.yeejoin.amos.boot.module.hygf.api.entity.TdHygfJpInverterWarn;
import com.yeejoin.amos.boot.module.hygf.api.service.ITdHygfJpInverterWarnService;
import com.yeejoin.amos.boot.module.hygf.api.tdenginemapper.TdHygfJpInverterWarnMapper;
import com.yeejoin.amos.boot.module.hygf.api.util.TimeUtil;

/**
 * 户用光伏监盘逆变器报警表服务实现类
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Service
public class TdHygfJpInverterWarnServiceImpl
		extends BaseService<TdHygfJpInverterWarnDto, TdHygfJpInverterWarn, TdHygfJpInverterWarnMapper>
		implements ITdHygfJpInverterWarnService {

	@Autowired
	JpStationServiceImpl jpStationServiceImpl;

	/**
	 * 分页查询
	 */
	public Page<TdHygfJpInverterWarnDto> queryForTdHygfJpInverterWarnPage(Page<TdHygfJpInverterWarnDto> pageParam,
			TdHygfJpInverterWarnDto tdHygfJpInverterWarnDto) {
		int pageNum = (int) pageParam.getCurrent();
		int pageSize = (int) pageParam.getSize();
		PageHelper.startPage(pageNum, pageSize);
		if (tdHygfJpInverterWarnDto.getState() != null) {
			String[] s = tdHygfJpInverterWarnDto.getState().split(",");
			tdHygfJpInverterWarnDto.setStates(Arrays.asList(s));
		}
		List<TdHygfJpInverterWarnDto> list = this.baseMapper.list(tdHygfJpInverterWarnDto);
		if (!list.isEmpty()) {
			list.forEach(i -> {
				JpStation jpStation = jpStationServiceImpl.getOne(new LambdaQueryWrapper<JpStation>()
						.eq(JpStation::getThirdStationId, i.getThirdStationId()));
				if (jpStation != null) {
					i.setAddress(jpStation.getAddress());
					i.setStationName(jpStation.getName());
					i.setArea(jpStation.getArea());
				}
				if (i.getStartTime() != null) {
					i.setStartTimeFormat(TimeUtil.dateFormat(i.getStartTime()));
				}
			});
		}
		PageInfo<TdHygfJpInverterWarnDto> page = new PageInfo(list);
		com.baomidou.mybatisplus.extension.plugins.pagination.Page<TdHygfJpInverterWarnDto> pagenew = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<TdHygfJpInverterWarnDto>();
		pagenew.setCurrent(pageNum);
		pagenew.setTotal(page.getTotal());
		pagenew.setSize(pageSize);
		pagenew.setRecords(page.getList());
		return pagenew;
	}

	/**
	 * 列表查询 示例
	 */
	public List<TdHygfJpInverterWarnDto> queryForTdHygfJpInverterWarnList() {
		return this.queryForList("", false);
	}

	public TdHygfJpInverterWarnDto queryByCreatedTime(long createdTime) {
		Map map = new HashMap<>();
		map.put("created_time", createdTime);
		TdHygfJpInverterWarnDto tdHygfJpInverterWarnDto = this.baseMapper.getByTime(createdTime);
		JpStation jpStation = jpStationServiceImpl.getOne(new LambdaQueryWrapper<JpStation>()
				.eq(JpStation::getThirdStationId, tdHygfJpInverterWarnDto.getThirdStationId()));
		if (jpStation != null) {
			tdHygfJpInverterWarnDto.setStationName(jpStation.getName());
			tdHygfJpInverterWarnDto.setStationContact(jpStation.getStationContact());
			tdHygfJpInverterWarnDto.setUserName(jpStation.getUserName());
			tdHygfJpInverterWarnDto.setUserPhone(jpStation.getUserPhone());
			tdHygfJpInverterWarnDto.setEmail(jpStation.getEmail());
			tdHygfJpInverterWarnDto.setAddress(jpStation.getAddress());
			tdHygfJpInverterWarnDto.setArea(jpStation.getArea());
			if (tdHygfJpInverterWarnDto.getRecoverTime() != null) {
				tdHygfJpInverterWarnDto
						.setRecoverTimeFormat(TimeUtil.dateFormat(tdHygfJpInverterWarnDto.getRecoverTime()));
				tdHygfJpInverterWarnDto.setTimeLongFormat(TimeUtil
						.longFormat(tdHygfJpInverterWarnDto.getRecoverTime() - tdHygfJpInverterWarnDto.getStartTime()));
			}
			if (tdHygfJpInverterWarnDto.getStartTime() != null) {
				tdHygfJpInverterWarnDto.setStartTimeFormat(TimeUtil.dateFormat(tdHygfJpInverterWarnDto.getStartTime()));
			}
		}

		return tdHygfJpInverterWarnDto;
	}
}