package com.yeejoin.amos.boot.module.jg.biz.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.experimental.UtilityClass;

import java.util.Map;
import java.util.stream.Collectors;

@UtilityClass
public class ObjectCleanerUtils {

    public static <T> T removeStringNullFields(T obj, Class<T> clazz) {
        if (obj == null) return null;
        ObjectMapper mapper = new ObjectMapper();

        Map<String, Object> map = mapper.convertValue(obj, new TypeReference<Map<String, Object>>() {});
        Map<String, Object> cleanedMap = map.entrySet().stream()
                .filter(e -> {
                    Object value = e.getValue();
                    return value != null && !(value instanceof String && "null".equalsIgnoreCase((String) value));
                })
                .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));

        return mapper.convertValue(cleanedMap, clazz);
    }
}