package com.yeejoin.amos.boot.module.app.flc.api.feign;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.feign.FeignConfiguration;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

@FeignClient(value = "AMOS-IDX", path = "idx", configuration =
        {FeignConfiguration.class})
public interface IdxFeignService {

    @RequestMapping("/dimensionTable/getTreeChildIds")
    ResponseModel<List<String>> getTreeChildIds(@RequestParam String dimensionTableId, @RequestParam String selectValue);

    /**
     * 查询表详情和表字段
     *
     * @param tableId
     * @return
     */
    @RequestMapping(value = "/table/{tableId}", method = RequestMethod.GET)
    ResponseModel<JSONObject> queryByTableId(@PathVariable String tableId);

    /**
     * */
    @RequestMapping(value = "/table/getPage", method = RequestMethod.GET)
    ResponseModel<Page<Map<String,Object>>> getPage(@RequestParam Map map);

    /**
     *根据record查询表格数据详情
     */
    @RequestMapping(value = "/report/form/getFormRecordById", method = RequestMethod.GET)
    ResponseModel<Map<String,Map<String,Object>>>getFormRecordById(@RequestParam Map map);


    /**
     * 多表单页提交 数据填报
     */
    @RequestMapping(value = "/table/batch/submit", method = RequestMethod.POST)
    ResponseModel batchSubmit(@RequestParam(required = false) String taskId,
                              @RequestParam(required = false) String planInstanceId,
                              @RequestParam(required = false) String topic,
                              @RequestParam(required = false) String tableName,
                              @RequestBody Map<String, Object> kv) throws Exception;

    /**
     * 多表单页修改数据修改
     */
    @RequestMapping(value = "/table/batch/update", method = RequestMethod.POST)
    ResponseModel batchUpdate(@RequestParam(required = false) String topic,
                              @RequestParam(required = false) String tableName,
                              @RequestBody Map<String, Object> kv) throws Exception;

    /**
     *更新任务
     */
    @RequestMapping(value = "/report/form/updateAmosTask/{taskId}", method = RequestMethod.POST)
    FeignClientResult<JSONObject> updateAmosTask(@PathVariable("taskId") String taskId, @RequestBody JSONObject object);



    /**
     *查询任务第一个填报单
     */
    @RequestMapping(value = "/report/form/getFirstFormByTaskId/{taskId}", method = RequestMethod.GET)
    FeignClientResult<JSONObject> getFirstTask(@PathVariable("taskId") String taskId);

    /**
     *查询工作流task
     */
    @RequestMapping(value = "/task-ins/{taskId}", method = RequestMethod.GET)
    FeignClientResult<Map<String, Object>> getTaskId(@PathVariable("taskId") String taskId);


    /**
     *通用表单提交 数据填报
     */
    @RequestMapping(value = "/table/submit", method = RequestMethod.POST)
    FeignClientResult<String> submit(@RequestParam(value = "pageId") long pageId,
                                     @RequestParam(value = "taskId", required = false) String taskId,
                                     @RequestParam(value = "planInstanceId", required = false) String planInstanceId,
                                     @RequestParam(value = "bizField", required = false) String bizField,
                                     @RequestParam(value = "topic", required = false) String topic,
                                     @RequestParam(value = "tableName", required = false) String tableName,
                                     @RequestBody Map<String, Object> kv) throws Exception;

}
