package com.yeejoin.amos.boot.module.jczs.biz.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jczs.api.dto.AlertCalledFormDto;
import com.yeejoin.amos.boot.module.jczs.api.dto.AlertCalledQueryDto;
import com.yeejoin.amos.boot.module.jczs.api.dto.VoiceRecordFileDto;
import com.yeejoin.amos.boot.module.jczs.api.entity.TzsCitInfo;
import com.yeejoin.amos.boot.module.jczs.api.entity.VoiceRecordFile;
import com.yeejoin.amos.boot.module.jczs.api.entity.VoiceRecordLog;
import com.yeejoin.amos.boot.module.jczs.api.mapper.VoiceRecordFileMapper;
import com.yeejoin.amos.boot.module.jczs.api.service.ICtiService;
import com.yeejoin.amos.boot.module.jczs.api.service.IVoiceRecordFileService;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.*;

/**
 * 通话记录附件服务实现类
 *
 * @author system_generator
 * @date 2021-08-03
 */
@Service
public class VoiceRecordFileServiceImpl extends BaseService<VoiceRecordFileDto,VoiceRecordFile,VoiceRecordFileMapper> implements IVoiceRecordFileService {

    @Autowired
    private VoiceRecordFileServiceImpl voiceRecordFileServiceImpl;

    private final Logger logger = LogManager.getLogger(VoiceRecordFileServiceImpl.class);

    @Autowired
    AlertCalledServiceImpl iAlertCalledService;

    @Autowired
    ICtiService ctiService;

    private volatile JSONArray ctiInfos;

    @Autowired
    EmqKeeper emqKeeper;

    @Autowired
    VoiceRecordLogServiceImpl iVoiceRecordLogServiceImpl;

    @Autowired
    TzsCitInfoServiceImpl citInfoService;

    /**
     * 分页查询
     */
    public Page<VoiceRecordFileDto> queryForVoiceRecordFilePage(Page<VoiceRecordFileDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<VoiceRecordFileDto> queryForVoiceRecordFileList()   {
        return this.queryForList("" , false);
    }



    @Override
    public void publishRecord(final VoiceRecordFileDto model) {
            // 保存到日志表中
        VoiceRecordLog log = new VoiceRecordLog();
        log.setAlertId(model.getAlertId());
        log.setConnectId(model.getConnectId());
        log.setIsDeal(false);
        log.setDealTimes(0);
        iVoiceRecordLogServiceImpl.save(log);
    }

    @Override
    public Page<VoiceRecordFileDto> queryRecordListByQueryDto(Page<VoiceRecordFileDto> page, String telStartTimeStr, String telEndTimeStr, String fileType, String tel, String workNum, String sortParam, String sortRule) {
        //获取当前登陆人所在单位的下的所有接警人员的userId
        Set<String> userIds = new HashSet<>();
        String regionCode = citInfoService.getReginParams().getCompany().getRegionCode();
        List<TzsCitInfo> citInfoList = citInfoService.list(new LambdaQueryWrapper<TzsCitInfo>().eq(TzsCitInfo::getRegionCode,regionCode));
        if(!ValidationUtil.isEmpty(citInfoList)){
            for(TzsCitInfo citInfo : citInfoList){
                userIds.add(citInfo.getCtiUserId());
            }
        }
        if (ValidationUtil.isEmpty(userIds)) {
            return page;
        }

        Page<List<VoiceRecordFileDto>>list = baseMapper.queryRecordListByQueryDto(page,
                telStartTimeStr,telEndTimeStr,fileType,tel,
                workNum,sortParam,sortRule,userIds);
        Page<VoiceRecordFileDto> page1 = new Page<>();
        List<VoiceRecordFileDto> resultDtoList = JSONArray.parseArray(JSONArray.toJSONString(list.getRecords()),VoiceRecordFileDto.class);
        page1.setCurrent(page.getCurrent());
        page1.setSize(page.getSize());
        page1.setTotal(list.getTotal());
        page1.setRecords(resultDtoList);
        return page1;
    }

    @Override
    public VoiceRecordFileDto getRecordById(Long sequenceNbr) {
        VoiceRecordFileDto record = baseMapper.getRecordById(sequenceNbr);
        return record;
    }

    @Override
    public List<VoiceRecordFileDto> selectExportData(String exportId) {
        List<String> ids = null;
        if(StringUtils.isNotEmpty(exportId)) {
            String[] idStr = exportId.split(",");
            ids = Arrays.asList(idStr);
        }
        return baseMapper.selectExportData(ids);
    }
}