package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplicationPushLog;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionApplicationPushLogMapper;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionApplicationEquipModel;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionApplicationModel;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionApplicationPushLogModel;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionApplicationPushLogService;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;
import java.util.Map;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-12-14
 */
@Service
public class JyjcInspectionApplicationPushLogServiceImpl extends BaseService<JyjcInspectionApplicationPushLogModel,JyjcInspectionApplicationPushLog,JyjcInspectionApplicationPushLogMapper> implements IJyjcInspectionApplicationPushLogService {
    /**
     * 分页查询
     */
    public Page<JyjcInspectionApplicationPushLogModel> queryForJyjcInspectionApplicationPushLogPage(Page<JyjcInspectionApplicationPushLogModel> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<JyjcInspectionApplicationPushLogModel> queryForJyjcInspectionApplicationPushLogList()   {
        return this.queryForList("" , false);
    }

    /**
     * 记录日志
     *
     *
     * @param params params
     * @return {@link  boolean}
     * @author yangyang
     * @throws
     * @date 2023/12/15 15:53
     */
    public boolean saveInspectionApplicationPushLog(Map<String, Object> params) {
        JyjcInspectionApplicationModel inspectionApplicationModel = (JyjcInspectionApplicationModel) params.get("inspectionApplication");
        List<JyjcInspectionApplicationEquipModel> applicationEquipModels = (List<JyjcInspectionApplicationEquipModel>) params.get("applicationEquips");
        JyjcInspectionApplicationPushLog logEntity = new JyjcInspectionApplicationPushLog();
        logEntity.setApplicationSeq(inspectionApplicationModel.getSequenceNbr());
        logEntity.setInspectionUnitCode(inspectionApplicationModel.getInspectionUnitCode());
        logEntity.setPushData(JSON.toJSONString(applicationEquipModels));
        logEntity.setPushStatus("0");
        return this.save(logEntity);
    }

}