package com.yeejoin.amos.boot.module.statistcs.biz.init;

import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.JGDPStatisticsServiceImpl;
import com.yeejoin.amos.component.robot.AmosRequestContext;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.context.RequestContext;

/**
 * @author Administrator
 */
@Component
public class DataInitAfterRuning implements ApplicationRunner {

    private JGDPStatisticsServiceImpl jgdpStatisticsService;

    private AmosRequestContext amosRequestContext;

    public DataInitAfterRuning(JGDPStatisticsServiceImpl jgdpStatisticsService, AmosRequestContext amosRequestContext) {
        this.jgdpStatisticsService = jgdpStatisticsService;
        this.amosRequestContext = amosRequestContext;
    }

    @Override
    public void run(ApplicationArguments args) {
        // 初始化数据到内存
        RequestContext.setAppKey(amosRequestContext.getAppKey());
        RequestContext.setProduct(amosRequestContext.getProduct());
        RequestContext.setToken(amosRequestContext.getToken());
        jgdpStatisticsService.init();
    }
}
