package com.yeejoin.amos.boot.module.app.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 安全追溯-维保备案信息表
 *
 * @author cpp
 * @date 2023-04-06 15:21:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="maintenanceRecordInfo", description="最近维保备案信息")
public class MaintenanceInfoModel extends BaseDto {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "")
    private String instanceId;
    @ApiModelProperty(value = "")
    private String status;
    @ApiModelProperty(value = "维保单位统一社会信用代码")
    private String meUnitCreditCode;
    @ApiModelProperty(value = "维保单位名称")
    private String meUnitName;
    @ApiModelProperty(value = "维保备案合同附件")
    private String repairInform;
    @ApiModelProperty(value = "维保合同开始日期")
    private Date informStart;
    @ApiModelProperty(value = "维保合同结束日期")
    private Date informEnd;
    @ApiModelProperty(value = "维保负责人姓名")
    private String meMaster;
    @ApiModelProperty(value = "维保负责人身份证")
    private String meMasterId;
    @ApiModelProperty(value = "紧急救援电话")
    private String emergencycall;
    @ApiModelProperty(value = "维保周期")
    private String meCycle;
    @ApiModelProperty(value = "大修周期")
    private String overhaulCycle;
    @ApiModelProperty(value = "24小时维保电话")
    private String me24Telephone;


}
