package com.yeejoin.amos.boot.module.jczs.api.enums;

/**
 * 
 * <pre>
 * 电梯接触器状态枚举
 * </pre>
 *
 * @author gwb
 * @version $Id: LiftContactorStatusEnum.java, v 0.1 2021年9月29日 上午9:08:16 gwb Exp $
 */
public enum LiftContactorStatusEnum{

	PULL(0,"吸合"),
	BREAK (1,"断开");

	/**
	 * 编码
	 */
	private Integer code;

	/**
	 * 名称
	 */
	private String name;


	// 构造方法
	private LiftContactorStatusEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}


	public Integer getCode() {
		return code;
	}
	
	public String getName()
	{
		return name;
	}
	
	public static LiftContactorStatusEnum getEnum(Integer code)
	{
		for (LiftContactorStatusEnum liftContactorStatusEnum : LiftContactorStatusEnum.values())
		{
			if (liftContactorStatusEnum.getCode().equals(code))
			{
				return liftContactorStatusEnum;
			}
		}
		return null;
	}
}
