package com.yeejoin.amos.boot.module.ccs.biz.service.impl;

import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.utils.oConvertUtils;
import com.yeejoin.amos.boot.module.ccs.api.dto.EquipmentDto;
import com.yeejoin.amos.boot.module.ccs.api.entity.Equipment;
import com.yeejoin.amos.boot.module.ccs.api.mapper.EquipmentMapper;
import com.yeejoin.amos.boot.module.ccs.api.service.IEquipmentService;

/**
 * 电力设备实现类
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Service
public class EquipmentServiceImpl extends BaseService<EquipmentDto,Equipment,EquipmentMapper> implements IEquipmentService {

	@Override
	public EquipmentDto getEquipmentByMrid(String mrid) {
		// TODO Auto-generated method stub
		LambdaQueryWrapper<Equipment> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(Equipment::getMrid, mrid);
		Equipment eq = this.getOne(wrapper);
		EquipmentDto eqDto = new EquipmentDto();
		if(ObjectUtils.isEmpty(eq)){
			return eqDto;
		}
		BeanUtils.copyProperties(eq, eqDto);
		eqDto.setImg(oConvertUtils.stringToList(eq.getImg()));
		eqDto.setFetchWaterImg(oConvertUtils.stringToList(eq.getFetchWaterImg()));
		eqDto.setPluggingImg(oConvertUtils.stringToList(eq.getPluggingImg()));
		eqDto.setPowerImg(oConvertUtils.stringToList(eq.getPowerImg()));
		eqDto.setRouteImg(oConvertUtils.stringToList(eq.getRouteImg()));
		return eqDto;
	}
 
}