package com.yeejoin.amos.fas.business.controller;

import java.util.Collection;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.fas.business.service.intfc.IPlanClassifyTreeService;
import com.yeejoin.amos.fas.business.vo.PlanClassifyTreeVo;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil2;
import com.yeejoin.amos.fas.core.util.ResponseModel;
import com.yeejoin.amos.fas.dao.entity.PlanClassifyTree;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

@RestController
@RequestMapping("/api/planClassifyTree")
@Api("预案分类树api")
public class PlanClassifyTreeController extends AbstractBaseController {

	@Autowired
	private IPlanClassifyTreeService planClassifyTreeService;

	@ApiOperation(value = "创建分类")
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	public ResponseModel create(@RequestBody PlanClassifyTree model) {
		AgencyUserModel user = getUserInfo();
		ReginParams reginParams = getSelectedOrgInfo();
		String compCode = getOrgCode(reginParams);
		model.setOrgCode(compCode);
		model.setCreator(user.getUserId());
		return CommonResponseUtil2.success(planClassifyTreeService.create(model));
	}

	@ApiOperation(value = "修改分类")
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/update", method = RequestMethod.PUT)
	public ResponseModel update(@RequestBody PlanClassifyTree model) {
		AgencyUserModel user = getUserInfo();
		ReginParams reginParams = getSelectedOrgInfo();
		String compCode = getOrgCode(reginParams);
		model.setOrgCode(compCode);
		model.setCreator(user.getUserId());
		return CommonResponseUtil2.success(planClassifyTreeService.update(model));
	}

	@ApiOperation(value = "删除分类")
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/{ids}", method = RequestMethod.DELETE)
	public ResponseModel delete(@PathVariable("ids") String ids) {
		return CommonResponseUtil2.success(planClassifyTreeService.delete(ids));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "查询分类树")
    @RequestMapping(value = "/tree", method = RequestMethod.GET)
	public ResponseModel getTree() {
		Collection<PlanClassifyTreeVo>  list = null;
		try {
			list = planClassifyTreeService.getTree();
		}catch (Exception e){
			e.printStackTrace();
			System.out.println(e.getStackTrace().toString());
		}
		return CommonResponseUtil2.success(list);
	}
}
