package com.yeejoin.amos.boot.module.ugp.api.Enum;

import com.yeejoin.amos.boot.module.common.api.enums.OrgPersonEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;

@Getter
@AllArgsConstructor
public enum OrgEnum {
    公司("COMPANY", "244", "公司",1),
    部门("DEPARTMENT", "245", "部门",2),
    人员("PERSON", "246", "人员",3),
    焊工("WELDER","247","焊工",3),
    建设单位负责人("CHARGE","254","建设单位负责人",3),
    企业管理员("ADMIN","248","企业管理员",3),
    建设单位("CONSTRUCTION","249","建设单位",1),
    安装单位("INSTALL","250","安装单位",1),
    设计单位("DESIGN","251","设计单位",1),
    监察单位("SUPERVISION","252","监察单位",1),
    监检机构("MONITORING","253","监检机构",1);

    private String key;
    private String code;
    private String name;
    /**
     * 1 公司 2 部门 3 人员
     */
    private Integer type;

    public static HashMap<String,String>  map= new HashMap();

    static {
        for(OrgPersonEnum orgPersonEnum:OrgPersonEnum.values()){
            map.put(orgPersonEnum.getName(),orgPersonEnum.getKey());
        }
    }
}
