package com.yeejoin.amos.boot.module.ugp.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 项目信息表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="ProjectDto", description="项目信息表")
public class ProjectDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "项目名称")
    private String name;

    @ApiModelProperty(value = "项目编号")
    private String code;

    @ApiModelProperty(value = "项目进度")
    private String progressStatus;

    @ApiModelProperty(value = "项目地点")
    private String address;

    @ApiModelProperty(value = "项目开工日期")
    private Date startDate;

    @ApiModelProperty(value = "项目安装区域代码")
    private String installRegionCode;

    @ApiModelProperty(value = "项目安装区域")
    private String installRegion;

    @ApiModelProperty(value = "建设单位id")
    private Long constructionUnitId;

    @ApiModelProperty(value = "建设单位名称")
    private String constructionUnit;

    @ApiModelProperty(value = "项目设计单位")
    private String designUnit;

    @ApiModelProperty(value = "项目设计单位id")
    private Long designUnitId;

    @ApiModelProperty(value = "安装单位id")
    private Long installationUnitId;

    @ApiModelProperty(value = "安装单位名称")
    private String installationUnit;

    @ApiModelProperty(value = "企业id")
    private Long companyId;

    @ApiModelProperty(value = "建设单位负责人id")
    private Long chargePersonId;

    @ApiModelProperty(value = "建设单位负责人名称")
    private String chargePerson;

    @ApiModelProperty(value = "组织机构代码")
    private String orgCode;

    @ApiModelProperty(value = "项目提交日期")
    private Date submitDate;

    @ApiModelProperty(value = "流程id")
    private String instanceId;

    @ApiModelProperty(value = "流程状态")
    private String status;

    @ApiModelProperty(value = "备注")
    private String remark;


}
