package com.yeejoin.amos.boot.module.ugp.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 智能监检管理表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="VerifyDto", description="智能监检管理表")
public class VerifyDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "项目id")
    private Long projectId;

    @ApiModelProperty(value = "编号")
    private String code;

    @ApiModelProperty(value = "检验检测阶段（焊前、工艺、耐压、敷设、定位）")
    private String stage;

    @ApiModelProperty(value = "被检查对象信息")
    private String targetInfo;

    @ApiModelProperty(value = "检验状态")
    private String status;

    @ApiModelProperty(value = "检验方式")
    private String type;

    @ApiModelProperty(value = "交检时间")
    private Date submitTime;

    @ApiModelProperty(value = "检验时间")
    private Date verifyTime;

    @ApiModelProperty(value = "检验检测单位id")
    private Long verifyUnitId;

    @ApiModelProperty(value = "检验负责人id")
    private Long chargerPersonId;

    @ApiModelProperty(value = "检验员id")
    private Long inspectorId;

}
