package com.yeejoin.amos.boot.module.ugp.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 智能监检管理表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_ugp_verify")
public class Verify extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 项目id
     */
	@TableField("project_id")
    private Long projectId;

    /**
     * 编号
     */
	@TableField("code")
    private String code;

    /**
     * 检验检测阶段（焊前、工艺、耐压、敷设、定位）
     */
	@TableField("stage")
    private String stage;

    /**
     * 被检查对象信息
     */
	@TableField("target_info")
    private String targetInfo;

    /**
     * 检验状态
     */
	@TableField("status")
    private String status;

    /**
     * 检验方式
     */
	@TableField("type")
    private String type;

    /**
     * 交检时间
     */
	@TableField("submit_time")
    private Date submitTime;

    /**
     * 检验时间
     */
	@TableField("verify_time")
    private Date verifyTime;

    /**
     * 检验检测单位id
     */
	@TableField("verify_unit_id")
    private Long verifyUnitId;

    /**
     * 检验负责人id
     */
	@TableField("charger_person_id")
    private Long chargerPersonId;

    /**
     * 检验员id
     */
	@TableField("inspector_id")
    private Long inspectorId;

}
