package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.yeejoin.amos.boot.module.ugp.api.dto.WelderEquipmentDto;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.ugp.api.entity.ProjectResource;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.List;

import com.yeejoin.amos.boot.module.ugp.biz.service.impl.ProjectResourceServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.ProjectResourceDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 项目资源表（包括焊工、管材、设备）
 *
 * @author system_generator
 * @date 2022-09-22
 */
@RestController
@Api(tags = "项目资源表（包括焊工、管材、设备）Api")
@RequestMapping(value = "/project-resource")
public class ProjectResourceController extends BaseController {

    @Autowired
    ProjectResourceServiceImpl projectResourceServiceImpl;

    /**
     * 新增项目资源表（包括焊工、管材、设备）
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增项目资源表（包括焊工、管材、设备）", notes = "新增项目资源表（包括焊工、管材、设备）")
    public ResponseModel<ProjectResourceDto> save(@RequestBody ProjectResourceDto model) {
        model = projectResourceServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新项目资源表（包括焊工、管材、设备）", notes = "根据sequenceNbr更新项目资源表（包括焊工、管材、设备）")
    public ResponseModel<ProjectResourceDto> updateBySequenceNbrProjectResource(@RequestBody ProjectResourceDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(projectResourceServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除项目资源表（包括焊工、管材、设备）", notes = "根据sequenceNbr删除项目资源表（包括焊工、管材、设备）")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(projectResourceServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个项目资源表（包括焊工、管材、设备）", notes = "根据sequenceNbr查询单个项目资源表（包括焊工、管材、设备）")
    public ResponseModel<ProjectResourceDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(projectResourceServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "项目资源表（包括焊工、管材、设备）分页查询", notes = "项目资源表（包括焊工、管材、设备）分页查询")
    public ResponseModel<Page<ProjectResourceDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size) {
        Page<ProjectResourceDto> page = new Page<ProjectResourceDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(projectResourceServiceImpl.queryForProjectResourcePage(page));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "项目资源表（包括焊工、管材、设备）列表全部数据查询", notes = "项目资源表（包括焊工、管材、设备）列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<ProjectResourceDto>> selectForList() {
        return ResponseHelper.buildResponse(projectResourceServiceImpl.queryForProjectResourceList());
    }

    /**
     * 焊机设备列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/welderpage")
    @ApiOperation(httpMethod = "GET", value = "焊机设备分页查询", notes = "焊机设备分页查询")
    public ResponseModel<Page<WelderEquipmentDto>> queryForPage11(
    		@RequestParam(value = "current") int current,
			@RequestParam(value = "size") int size,
			@RequestParam(value = "name", required = false) String name,
			@RequestParam(value = "type", required = false) String type
	) {
        Page<WelderEquipmentDto> page = new Page<WelderEquipmentDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(projectResourceServiceImpl.installNoticeMsgList(page, name, type));
    }

    /**
     * 项目设备新增
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/welderSave")
    @ApiOperation(httpMethod = "POST", value = "项目设备新增", notes = "项目设备新增")
    public ResponseModel<Boolean> welderSave(@RequestBody WelderEquipmentDto welderEquipmentDto){
        this.projectResourceServiceImpl.welderSave(welderEquipmentDto);
        return ResponseHelper.buildResponse(true);
    }

    /**
     * 项目设备删除
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @DeleteMapping(value = "/welderDelete")
    @ApiOperation(httpMethod = "Delete", value = "项目设备删除", notes = "项目设备删除")
    public ResponseModel<Boolean> welderDelete(
            @RequestParam String ids
    ){
        this.projectResourceServiceImpl.welderDelete(ids);
        return ResponseHelper.buildResponse(true);
    }

	/**
	 * 绑定设备跟项目
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "POST",value = "绑定设备跟项目",   notes = "绑定设备跟项目")
	@PostMapping(value = "/saveId")
	public ResponseModel<ProjectResource> saveId(@RequestBody JSONObject jsonObject) {
		return ResponseHelper.buildResponse(projectResourceServiceImpl.saveIds(jsonObject));
	}
}
