package com.yeejoin.amos.boot.module.ugp.biz.controller;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.sql.SQLIntegrityConstraintViolationException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;

import com.yeejoin.amos.boot.module.ugp.biz.service.impl.SuperviseRuleServiceImpl;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.SuperviseRuleDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 监管区域规则表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@RestController
@Api(tags = "监管区域规则表Api")
@RequestMapping(value = "/supervise-rule")
public class SuperviseRuleController extends BaseController {

    @Autowired
    SuperviseRuleServiceImpl superviseRuleServiceImpl;

    /**
     * 新增监管区域规则表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增监管区域规则表", notes = "新增监管区域规则表")
	public ResponseModel<SuperviseRuleDto> save(@RequestBody SuperviseRuleDto model) {
    	model.setCreateDate(new Date());
	    model = superviseRuleServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@PutMapping(value = "")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新监管区域规则表", notes = "根据sequenceNbr更新监管区域规则表")
	public ResponseModel<SuperviseRuleDto> updateBySequenceNbrSuperviseRule(@RequestBody SuperviseRuleDto model,@RequestParam(value = "sequenceNbr") Long sequenceNbr) {
		model.setRecDate(new Date());
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(superviseRuleServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @DeleteMapping(value = "")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除监管区域规则表", notes = "根据sequenceNbr删除监管区域规则表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @RequestParam(value = "sequenceNbr") String sequenceNbr){
		List<Long> ids = Arrays.stream(sequenceNbr.split(",")).map(Long::valueOf).collect(Collectors.toList());
		try{
			return ResponseHelper.buildResponse(superviseRuleServiceImpl.removeByIds(ids));
		} catch (Exception e){
			return ResponseHelper.buildResponse(false);
		}
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个监管区域规则表",  notes = "根据sequenceNbr查询单个监管区域规则表")
	public ResponseModel<SuperviseRuleDto> selectOne(@RequestParam("sequenceNbr") Long sequenceNbr) {
	    return ResponseHelper.buildResponse(superviseRuleServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "监管区域规则表分页查询",  notes = "监管区域规则表分页查询")
	public ResponseModel<Page<SuperviseRuleDto>> queryForPage(
			@RequestParam(value = "current") int current,
			@RequestParam(value = "size") int size,
			int adminRegionCode,
			@RequestParam(value = "superviseDeptId", required = false) Long superviseDeptId,
			@RequestParam(value = "inspectionUnitId", required = false) Long inspectionUnitId
	) {
	    Page<SuperviseRuleDto> page = new Page<SuperviseRuleDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(superviseRuleServiceImpl.queryForSuperviseRulePage(page, superviseDeptId, inspectionUnitId));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "监管区域规则表列表全部数据查询",   notes = "监管区域规则表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<SuperviseRuleDto>> selectForList() {
	    return ResponseHelper.buildResponse(superviseRuleServiceImpl.queryForSuperviseRuleList());
	}
}
