package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.ugp.api.dto.WelderEquipmentDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.Equipment;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.ugp.api.Enum.ProjectResourceEnum;
import com.yeejoin.amos.boot.module.ugp.api.entity.ProjectResource;
import com.yeejoin.amos.boot.module.ugp.api.mapper.EquipmentMapper;
import com.yeejoin.amos.boot.module.ugp.api.mapper.ProjectResourceMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IProjectResourceService;
import com.yeejoin.amos.boot.module.ugp.api.dto.ProjectResourceDto;
import org.aspectj.weaver.ast.Test;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.ArrayList;
import java.util.Arrays;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.Map;

import static com.yeejoin.amos.boot.module.ugp.api.Enum.ProjectResourceEnum.*;

/**
 * 项目资源表（包括焊工、管材、设备）服务实现类
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Service
public class ProjectResourceServiceImpl extends BaseService<ProjectResourceDto,ProjectResource,ProjectResourceMapper> implements IProjectResourceService {

    @Autowired
    ProjectResourceMapper projectResourceMapper;

    @Autowired
    EquipmentMapper equipmentMapper;

    /**
     * 分页查询
     */
    public Page<ProjectResourceDto> queryForProjectResourcePage(Page<ProjectResourceDto> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<ProjectResourceDto> queryForProjectResourceList() {
        return this.queryForList("", false);
    }

    @Override
    public Page<WelderEquipmentDto> installNoticeMsgList(Page<WelderEquipmentDto> page, String name, String type) {
        return this.projectResourceMapper.WelderEquipment(page, name, type);
    }

    @Override
    public Page<WelderEquipmentDto> selectByName(Page<WelderEquipmentDto> page, String name, String unit) {
        return null;
    }

    @Override
    public Page<WelderEquipmentDto> selectByInfo(Page<WelderEquipmentDto> page, Test info, String unit) {
        return null;
    }

    @Override
    public WelderEquipmentDto customSelectById(Long sequenceNbr) {
        return null;
    }

    /**
     * 项目设备新增
     */
    @Transactional()
    public void welderSave(WelderEquipmentDto welderEquipmentDto) {
        // 保存设备
        Equipment equipment = new Equipment();
        BeanUtils.copyProperties(welderEquipmentDto, equipment);
        equipmentMapper.insert(equipment);

        // 处理附件
        MultipartFile[] files = welderEquipmentDto.getFiles();

        // 保存项目与设备对应关系
        ProjectResource projectResource = new ProjectResource();
        projectResource.setProjectId(welderEquipmentDto.getProjectId());
        projectResource.setName(equipment.getName());
        projectResource.setType("equipment");
        projectResource.setResourceId(equipment.getSequenceNbr());
        projectResourceMapper.insert(projectResource);
    }

    /**
     * 项目设备删除
     * @param ids
     */
    @Transactional
    public void welderDelete(String ids) {
        this.list(new QueryWrapper<ProjectResource>().lambda().in(
                ProjectResource::getSequenceNbr,
                Arrays.stream(ids.split(",")).map(Long::valueOf).collect(Collectors.toList()))
        ).forEach(item -> {
          this.equipmentMapper.deleteById(item.getResourceId());
          this.projectResourceMapper.deleteById(item.getSequenceNbr());
        });
    }

    /**
     * 存储项目设备关系
     */
    public ProjectResource saveIds(JSONObject jsonObject) {
        JSONArray subForm = jsonObject.getJSONArray("subForm");
        ProjectResource projectResource = new ProjectResource();

        for (Object json2 : subForm) {
            String select = JSON.parseObject(JSON.toJSONString(json2)).getString("select");
//            if (!jsonObject.getString("sequenceNbr").isEmpty()){
//                jsonObject.getString("sequenceNbr");
//            }
            String SequenceNbr = jsonObject.getString("SequenceNbr");
            String type = jsonObject.getString("type");
            if (type.equals(设备资源.getStatus())) {
                projectResource.setType(设备资源.getState());
            }
            if (type.equals(焊工资源.getStatus())) {
                projectResource.setType(焊工资源.getState());
            }
            if (type.equals(管材资源.getStatus())) {
                projectResource.setType(管材资源.getState());
            }
            projectResource.setProjectId(Long.valueOf(SequenceNbr));
            projectResource.setResourceId(Long.valueOf(select));
            this.save(projectResource);

        }
        return projectResource;


    }
}