package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarm;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarmLog;
import com.yeejoin.equipmanage.common.utils.DateUtils;
import com.yeejoin.equipmanage.mapper.EquipmentSpecificAlarmLogMapper;
import com.yeejoin.equipmanage.service.IEquipmentSpecificAlarmLogService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author keyong
 * @title: EquipmentSpecificAlarmLogServiceImpl
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2021/8/19 10:37
 */
@Service
public class EquipmentSpecificAlarmLogServiceImpl extends ServiceImpl<EquipmentSpecificAlarmLogMapper, EquipmentSpecificAlarmLog> implements IEquipmentSpecificAlarmLogService {

    @Autowired
    EquipmentSpecificAlarmLogMapper equipmentSpecificAlarmLogMapper;

    @Override
    public void updateAlarmLogByIotCodeAndIndexKey(EquipmentSpecificAlarm equipmentSpecificAlarm) {
        equipmentSpecificAlarmLogMapper.updateAlarmLogByIotCodeAndIndexKey(equipmentSpecificAlarm);
    }

    @Override
    public List<EquipmentSpecificAlarmLog> getIsConfirmByAlarmId(Long equipmentSpecificId, String equipmentSpecificIndexKey, String isConfirm) {
        List<EquipmentSpecificAlarmLog> list = equipmentSpecificAlarmLogMapper.getIsConfirmByAlarmId(equipmentSpecificId, equipmentSpecificIndexKey, isConfirm);
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Lists.newArrayList();
    }

    @Override
    public Map<String, Object> equipAlarmLink(String date) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtils.isBlank(date)) {
            date = DateUtils.convertDateToString(new Date(), "yyyy-MM-dd");
        }
        String monthDate = date.substring(0, 7);
        //  获取今日告警设备、日环比
        Map<String, Object> alarmEquipDayLink = equipmentSpecificAlarmLogMapper.alarmEquipLink(date, "%Y-%m-%d", null);
        //  获取今日告警设备、月环比
        Map<String, Object> alarmEquipMonthLink = equipmentSpecificAlarmLogMapper.alarmEquipLink(monthDate, "%Y-%m", null);
        //  获取未消除告警设备，日环比
        Map<String, Object> unCleanAlarmEquipDayLink = equipmentSpecificAlarmLogMapper.unCleanAlarmEquipLink(date, "%Y-%m-%d", "unClean");
        //  获取未消除告警设备，月环比
        Map<String, Object> unCleanAlarmEquipMonthLink = equipmentSpecificAlarmLogMapper.unCleanAlarmEquipLink(monthDate, "%Y-%m", "unClean");
        map.put("alarmEquipDayLink", alarmEquipDayLink);
        map.put("alarmEquipMonthLink", alarmEquipMonthLink);
        map.put("unCleanAlarmEquipDayLink", unCleanAlarmEquipDayLink);
        map.put("unCleanAlarmEquipMonthLink", unCleanAlarmEquipMonthLink);
        return map;
    }
}
