package com.yeejoin.amos.boot.module.jcs.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.common.api.dto.RequestData;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertCalledZhDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertCalled;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
* 警情接警记录 Mapper 接口
*
* @author tb
* @date 2021-06-17
*/
public interface AlertCalledMapper extends BaseMapper<AlertCalled> {

    /**
     * 接警情况统计-交接班用
     *
     * @param beginDate
     * @param endDate
     * @return
     */
    Map<String, Integer> queryAlertStatusCount(@Param("beginDate") String beginDate, @Param("endDate") String endDate);

    List<AlertCalledZhDto> alertCalledListByAlertStatus(@Param("par")RequestData par);
}
