package com.yeejoin.amos.boot.module.command.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.command.biz.service.impl.FrontlineLiaisonServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.command.api.dto.FrontlineLiaisonDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 前线联络员
 *
 * @author system_generator
 * @date 2021-07-22
 */
@RestController
@Api(tags = "前线联络员Api")
@RequestMapping(value = "/command/frontline-liaison")
public class FrontlineLiaisonController extends BaseController {

    @Autowired
    FrontlineLiaisonServiceImpl frontlineLiaisonServiceImpl;

    /**
     * 新增前线联络员
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增前线联络员", notes = "新增前线联络员")
	public ResponseModel<FrontlineLiaisonDto> save(@RequestBody FrontlineLiaisonDto model) {
	    model = frontlineLiaisonServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新前线联络员", notes = "根据sequenceNbr更新前线联络员")
	public ResponseModel<FrontlineLiaisonDto> updateBySequenceNbrFrontlineLiaison(@RequestBody FrontlineLiaisonDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(frontlineLiaisonServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除前线联络员", notes = "根据sequenceNbr删除前线联络员")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(frontlineLiaisonServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个前线联络员",  notes = "根据sequenceNbr查询单个前线联络员")
	public ResponseModel<FrontlineLiaisonDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(frontlineLiaisonServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "前线联络员分页查询",  notes = "前线联络员分页查询")
	public ResponseModel<Page<FrontlineLiaisonDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size,@RequestParam(value = "alertCalledId")Long alertCalledId) {
	    Page<FrontlineLiaisonDto> page = new Page<FrontlineLiaisonDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(frontlineLiaisonServiceImpl.queryForFrontlineLiaisonPage(page,alertCalledId));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "前线联络员列表全部数据查询",   notes = "前线联络员列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<FrontlineLiaisonDto>> selectForList() {
	    return ResponseHelper.buildResponse(frontlineLiaisonServiceImpl.queryForFrontlineLiaisonList());
	}
}
