package com.yeejoin.amos.boot.module.common.biz.controller;

import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import com.yeejoin.amos.boot.module.common.biz.service.impl.LinkageUnitServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.LinkageUnitDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;


/**
 * 联动单位
 *
 * @author system_generator
 * @date 2021-07-16
 */
@RestController
@Api(tags = "联动单位Api")
@RequestMapping(value = "/common/linkage-unit")
public class LinkageUnitController extends BaseController {

    @Autowired
    LinkageUnitServiceImpl linkageUnitServiceImpl;

    /**
     * 新增联动单位
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增联动单位", notes = "新增联动单位")
    public ResponseModel<LinkageUnitDto> save(@RequestBody LinkageUnitDto model) {
        model = linkageUnitServiceImpl.saveModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新联动单位", notes = "根据sequenceNbr更新联动单位")
    public ResponseModel<LinkageUnitDto> updateBySequenceNbrLinkageUnit(@RequestBody LinkageUnitDto model,
                                                                        @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(linkageUnitServiceImpl.updateById(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除联动单位", notes = "根据sequenceNbr删除联动单位")
    public ResponseModel<Boolean> deleteBySequenceNbr(@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(linkageUnitServiceImpl.deleteById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbrList 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/batch_delete")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除联动单位", notes = "根据sequenceNbr删除联动单位")
    public ResponseModel<Boolean> batchDeleteBySequenceNbrList(@RequestParam(value = "sequenceNbrList") List<Long> sequenceNbrList) {
        return ResponseHelper.buildResponse(linkageUnitServiceImpl.batchDelete(sequenceNbrList));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个联动单位", notes = "根据sequenceNbr查询单个联动单位")
    public ResponseModel<LinkageUnitDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(linkageUnitServiceImpl.queryOne(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "联动单位分页查询", notes = "联动单位分页查询")
    public ResponseModel<Page<LinkageUnitDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size, String unitName, String linkageUnitType, String inAgreement) {
        Page<LinkageUnitDto> page = new Page<LinkageUnitDto>();
        page.setCurrent(current);
        page.setSize(size);
        Page<LinkageUnitDto> linkageUnitDtoPage = linkageUnitServiceImpl.queryForLinkageUnitPage(page, false,
                unitName, linkageUnitType);
        Date now = new Date();
        List<LinkageUnitDto> linkageUnitDtoList = linkageUnitDtoPage.getRecords().stream().map(item -> {
            boolean isInAgreement = DateUtils.belongCalendar(now, item.getAgreementStartDate(),
                    item.getAgreementEndDate());
            item.setInAgreement(isInAgreement ? "是" : "否");
            return item;
        }).filter(item -> StringUtils.isEmpty(inAgreement) || inAgreement.equals(item.getInAgreement())).collect(Collectors.toList());
        linkageUnitDtoPage.setRecords(linkageUnitDtoList);
        return ResponseHelper.buildResponse(linkageUnitDtoPage);
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "联动单位列表全部数据查询", notes = "联动单位列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<LinkageUnitDto>> selectForList() {
        return ResponseHelper.buildResponse(linkageUnitServiceImpl.queryForLinkageUnitList(false));
    }
}
