package com.yeejoin.amos.boot.module.common.biz.service.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.boot.module.common.api.dto.FirefightersExcelDto;
import com.yeejoin.amos.boot.module.common.api.dto.FirefightersInfoDto;
import com.yeejoin.amos.boot.module.common.api.dto.FirefightersZhDto;
import com.yeejoin.amos.boot.module.common.api.entity.FirefightersContacts;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.utils.Menu;
import com.yeejoin.amos.boot.biz.common.utils.TreeParser;
import com.yeejoin.amos.boot.module.common.api.dto.FirefightersDto;
import com.yeejoin.amos.boot.module.common.api.entity.DataDictionary;
import com.yeejoin.amos.boot.module.common.api.entity.Firefighters;
import com.yeejoin.amos.boot.module.common.api.mapper.FirefightersMapper;
import com.yeejoin.amos.boot.module.common.api.service.IFirefightersService;

/**
 * 消防队员 服务实现类
 *
 * @author tb
 * @date 2021-06-07
 */
@Service
public class FirefightersServiceImpl extends BaseService<FirefightersDto, Firefighters, FirefightersMapper> implements IFirefightersService {


    @Autowired
    FirefightersMapper firefightersMapper;
    @Autowired
    DataDictionaryServiceImpl iDataDictionaryService;
    @Autowired
    FirefightersContactsServiceImpl firefightersContactsService;

    @Override
    public List<FirefightersZhDto> getFirefighters(int pageNum, int pageSize, FirefightersDto par) {
        return firefightersMapper.getFirefighters(pageNum, pageSize, par);
    }

    @Override
    public Map<String, Long> getFirefightersCount(int pageNum, int pageSize, FirefightersDto par) {
        // TODO Auto-generated method stub
        return firefightersMapper.getFirefightersCount(pageNum, pageSize, par);
    }

    @Override
    public Map<String, Object> listToSelectById(Long id) {
        // TODO Auto-generated method stub
        return firefightersMapper.listToSelectById(id);
    }

    @Override
    public void saveFirefighters(FirefightersInfoDto firefighters) {
        Firefighters firefighter = firefighters.getFirefighters();
        save(firefighter);
        FirefightersContacts firefightersContact = firefighters.getFirefightersContacts();
        firefightersContact.setFirefightersId(firefighter.getSequenceNbr());
        firefightersContactsService.save(firefightersContact);
        firefighters.setFirefightersContacts(firefightersContact);
        firefighters.setFirefighters(firefighter);
    }

    /**
     * 导出列表
     */
    public List<FirefightersExcelDto> exportToExcel(@Condition(Operator.eq) Boolean isDelete) {
        return firefightersMapper.exportToExcel(isDelete);
    }


    @Override
    public List<Menu> getFirefightersJobTitleCount() throws Exception {

        QueryWrapper<DataDictionary> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("type", "GWMC");
        queryWrapper.orderByAsc("sort_num");
        Collection<DataDictionary> list = iDataDictionaryService.list(queryWrapper);
        List<Menu> menus = TreeParser.getTree(null, list, DataDictionary.class.getName(), "getCode", 0, "getName",
                "getParent", firefightersMapper.getFirefightersJobTitleCount());
        return menus;
    }


}
