package com.yeejoin.amos;

import java.net.InetAddress;
import java.net.UnknownHostException;

import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.typroject.tyboot.core.restful.exception.GlobalExceptionHandler;

/**
 * Created by magintursh on 2017-05-03.
 */

@EnableScheduling
@EnableAsync
@MapperScan({"com.yeejoin.amos.knowledgebase.face.orm.dao*",
        "org.typroject.tyboot.face.*.orm.dao*",
        "org.typroject.tyboot.core.auth.face.orm.dao*",
        "org.typroject.tyboot.component.*.face.orm.dao*"})
@SpringBootApplication(scanBasePackages = {"com.yeejoin.amos","org.typroject"})
public class KnowledgebaseApplication {
	private static final Logger logger = LoggerFactory.getLogger(KnowledgebaseApplication.class);
    public static void main(String[] args)  throws UnknownHostException{
    	ConfigurableApplicationContext context = new SpringApplicationBuilder(KnowledgebaseApplication.class).web(WebApplicationType.SERVLET).run(args);
        GlobalExceptionHandler.setAlwaysOk(true);
        Environment env = context.getEnvironment();
        String ip = InetAddress.getLocalHost().getHostAddress();
        String port = env.getProperty("server.port");
        String path = env.getProperty("server.servlet.context-path");
        GlobalExceptionHandler.setAlwaysOk(true);
        logger.info("\n----------------------------------------------------------\n\t" +
                "Application Amos-Biz-Boot is running! Access URLs:\n\t" +
                "Swagger文档: \thttp://" + ip + ":" + port + path + "/doc.html\n" +
                "----------------------------------------------------------");
    }
}
