package com.yeejoin.amos.boot.module.jcs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import com.yeejoin.amos.boot.module.common.api.entity.SourceFile;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
import java.util.Map;

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("jc_situation_detail")
@ApiModel(value="AlertCalled对象", description="警情接警记录")
public class JcSituationDetail extends BaseEntity {

    @ApiModelProperty(value = "报送内容")
    private String info;

    @ApiModelProperty(value = "类型")
    private String infoType = "指令下发";

    @ApiModelProperty(value = "警情ID")
    private Long alertCalledId;

    @ApiModelProperty(value = "图片")
    @TableField(exist = false)
    private List<String> photos;
}
