package com.yeejoin.precontrol.common.after.runner;

import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.privilege.model.IdPasswordAuthModel;
import com.yeejoin.amos.feign.privilege.model.RoleModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.precontrol.common.constant.Constant;
import com.yeejoin.precontrol.common.entity.Company;
import com.yeejoin.precontrol.common.service.ICompanyService;
import com.yeejoin.precontrol.common.utils.DesUtil;
import com.yeejoin.precontrol.common.utils.RedisUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author DELL
 */
@Component
@EnableScheduling
@Slf4j
public class CompanyAndPersonTask {

    /**
     * 产品号
     */
    @Value("${admin.product}")
    String product;
    /**
     * 产品密钥
     */
    @Value("${admin.appkey}")
    String appkey;

    /**
     * 账户
     */
    @Value("${admin.user}")
    String user;
    /**
     * 密码
     */
    @Value("${admin.password}")
    String password;
    
	@Value("${amos.secret.key}")
	String secretKey;

    @Autowired
    RedisUtil redisUtil;

    @Autowired
    ICompanyService companyService;

    /**
     * 启动完成后 执行  企业  角色 人员 数据rides缓存
     */
    /**
     * 每天凌晨2点
     */
    @Scheduled(cron = "0 0 2 * * ?")
    public void run() {
        log.info("启动完成后执行rides缓存数据任务开始--------------->");
        try {
            setPlatFormAccess();
            company();
            role();
            violationNature();
		} catch (Exception e) {
			e.printStackTrace();
		}
        log.info("启动完成后执行rides缓存数据任务结束--------------->");
    }

    public void setPlatFormAccess() {
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appkey);
        RequestContext.setToken("token");
        IdPasswordAuthModel authModel = new IdPasswordAuthModel();
        authModel.setLoginId(user);
        authModel.setPassword(DesUtil.encode(password, secretKey));
        FeignClientResult<Map<String, String>> authResult = Privilege.authClient.idpassword(authModel);
        String token = authResult.getResult().get("token");
        RequestContext.setToken(token);
    }

    // 公司
    public void company() {
        try {
            List<Company> list = companyService.list();
            if (list != null && list.size() > 0) {
                // 缓存新数据
                for (Company company : list) {
                    Long companyId = company.getId();
                    // 根据id 查询公司下人员
//                    FeignClientResult<List<AgencyUserModel>> companyList = Privilege.agencyUserClient.queryByCompanyId(companyId, null, null, false);
//                    if (companyList != null && companyList.getResult() != null) {
//                        redisUtil.set(Constant.COMPANY_LIST + companyId, companyList.getResult());
//                        log.info(" companyId：{} 执行完成。。。", companyId);
//                    }
                    //根据公司id 查询子部门和人员
                    FeignClientResult<CompanyModel> companyChildres = Privilege.departmentClient.queryByCompanyChilds(companyId);
                    if (companyChildres != null && companyChildres.getResult() != null) {
                        redisUtil.set(Constant.COMPANY_CHILDRES_LIST + companyId, companyChildres.getResult());
                        log.info(" companyId children：{} 执行完成。。。", companyId);
                    }
                }
            }
        } catch (Exception e) {
            log.error("company redis fail");
        }
    }


    // 角色
    public void role() {
        try {
            //根据所有角色
            FeignClientResult<List<RoleModel>> roles = Privilege.roleClient.queryRoleList(null, null);
            if (roles != null && roles.getResult() != null) {
                redisUtil.set(Constant.ROLE_LIST, roles.getResult());
            }
        } catch (Exception e) {
            log.error("role redis fail");
        }
    }

    // 违章类型  VIOLATION_NATURE  平台数据字典
    public void violationNature() {
        try {
            //违章类型
            FeignClientResult<List<DictionarieValueModel>> feignClientResult = Systemctl.dictionarieClient.dictValues("VIOLATION_NATURE");
            if (feignClientResult != null && feignClientResult.getResult() != null) {
                List<DictionarieValueModel> dicts = feignClientResult.getResult();
                List<String> valList = dicts.stream().map(DictionarieValueModel::getDictDataValue).collect(Collectors.toList());
                redisUtil.set(Constant.VIOLATION_NATURE, valList);
            }
        } catch (Exception e) {
            log.error("role redis fail");
        }
    }

}
