package com.yeejoin.precontrol.common.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.entity.AppMenu;
import com.yeejoin.precontrol.common.entity.AppMenuConfig;
import com.yeejoin.precontrol.common.entity.Person;
import com.yeejoin.precontrol.common.mapper.AppMenuConfigMapper;
import com.yeejoin.precontrol.common.service.IAppMenuConfigService;
import com.yeejoin.precontrol.common.service.IAppMenuService;
import com.yeejoin.precontrol.common.service.IPersonService;

/**
 * 用户app菜单配置表 服务实现类
 *
 * @author duanwei
 * @date 2021-02-22
 */
@Service
public class AppMenuConfigServiceImpl extends ServiceImpl<AppMenuConfigMapper, AppMenuConfig>
		implements IAppMenuConfigService {
	@Autowired
	private IPersonService personService;
	@Autowired
	private IAppMenuService appMenuService;
	
	@Autowired
	private IAppMenuConfigService appMenuConfigService;

	/**
	 * @Version 1.0
	 * @Description 同步用户应用数据
	 * @Return Boolean
	 * @Exception
	 * @Date 2021/4/21 16:06
	 */
	@Override
	public Map<String, Boolean> syncUserAppMenu() {
		Map<String, Boolean> map = new HashMap<>(16);
		List<Person> personList = personService.list();
		List<AppMenu> appMenus = appMenuService.list();
		if (CollectionUtils.isNotEmpty(personList) && CollectionUtils.isNotEmpty(appMenus)) {
			personList.stream().forEach(item -> {
				List<AppMenuConfig> appMenuConfigs = new ArrayList<>();
				appMenus.stream().forEach(app -> {
					AppMenuConfig a = appMenuConfigService.getOne(new LambdaQueryWrapper<AppMenuConfig>()
							.eq(AppMenuConfig::getUserId, item.getUserId()).eq(AppMenuConfig::getMenuKey, app.getMenuKey()));
					if(a==null) 
					{
						AppMenuConfig appMenuConfig = new AppMenuConfig();
						appMenuConfig.setMenuKey(app.getMenuKey());
						appMenuConfig.setMenuLabel(app.getMenuLabel());
						appMenuConfig.setMenuIcon(app.getMenuIcon());
						appMenuConfig.setSort(1);
						appMenuConfig.setUserId(String.valueOf(item.getUserId()));
						appMenuConfig.setPage(app.getPage());
						appMenuConfig.setIsMust(Boolean.FALSE);
						appMenuConfig.setIsUsed(Boolean.FALSE);
						if (app.getMenuKey().equals("riskWork")) {
							appMenuConfig.setIsMust(Boolean.TRUE);
							appMenuConfig.setIsUsed(Boolean.TRUE);
						}
						if (app.getMenuKey().equals("violateCheck")) {
							appMenuConfig.setIsMust(Boolean.TRUE);
							appMenuConfig.setIsUsed(Boolean.TRUE);
						}
						if (app.getMenuKey().equals("konwledgePush")) {
							appMenuConfig.setIsMust(Boolean.TRUE);
							appMenuConfig.setIsUsed(Boolean.TRUE);
						}
						if (app.getMenuKey().equals("technology")) {
							appMenuConfig.setIsMust(Boolean.TRUE);
							appMenuConfig.setIsUsed(Boolean.TRUE);
						}
						Boolean flag = appMenuConfigs.add(appMenuConfig);
						map.put("saveFlag", flag);
					}
				});
				this.saveBatch(appMenuConfigs);
			});
		}
		return map;
	}

	@Override
	public Map<String, Boolean> updateUserAppMenu(Long id) {
		Map<String, Boolean> map = new HashMap<>(16);
		if (id == null) {
			return map;
		}
		List<Person> personList = personService.list();
		List<AppMenu> appMenus = appMenuService.list(new LambdaQueryWrapper<AppMenu>().eq(AppMenu::getId, id));
		if (CollectionUtils.isNotEmpty(personList) && CollectionUtils.isNotEmpty(appMenus)) {
			personList.stream().forEach(item -> {
				List<AppMenuConfig> appMenuConfigs = new ArrayList<>();
				appMenus.stream().forEach(app -> {
					AppMenuConfig appMenuConfig = new AppMenuConfig();
					appMenuConfig.setMenuKey(app.getMenuKey());
					appMenuConfig.setMenuLabel(app.getMenuLabel());
					appMenuConfig.setMenuIcon(app.getMenuIcon());
					appMenuConfig.setSort(1);
					appMenuConfig.setUserId(String.valueOf(item.getUserId()));
					appMenuConfig.setPage(app.getPage());
					appMenuConfig.setIsMust(Boolean.FALSE);
					appMenuConfig.setIsUsed(Boolean.FALSE);
					if (app.getMenuKey().equals("riskWork")) {
						appMenuConfig.setIsMust(Boolean.TRUE);
						appMenuConfig.setIsUsed(Boolean.TRUE);
					}
					if (app.getMenuKey().equals("violateCheck")) {
						appMenuConfig.setIsMust(Boolean.TRUE);
						appMenuConfig.setIsUsed(Boolean.TRUE);
					}
					if (app.getMenuKey().equals("konwledgePush")) {
						appMenuConfig.setIsMust(Boolean.TRUE);
						appMenuConfig.setIsUsed(Boolean.TRUE);
					}
					if (app.getMenuKey().equals("technology")) {
						appMenuConfig.setIsMust(Boolean.TRUE);
						appMenuConfig.setIsUsed(Boolean.TRUE);
					}
					Boolean flag = appMenuConfigs.add(appMenuConfig);
					map.put("saveFlag", flag);
				});
				this.saveBatch(appMenuConfigs);
			});
		}
		return map;
	}

}
