package com.yeejoin.equipmanage.controller;

import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.common.vo.BigScreenVo;
import com.yeejoin.equipmanage.service.IFireFightingSystemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

@RestController
@Api(tags = "一张图大屏API")
@RequestMapping(value = "/bigScreen", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class BigScreenController {

    @Autowired
    private IFireFightingSystemService iFireFightingSystemService;

    @GetMapping(value = "/list")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "系统、消防水池、工业水池、水源总容积、消防车辆", notes = "系统、消防水池、工业水池、水源总容积、消防车辆")
    public ResponseModel<BigScreenVo> getSystemAlarmInfoNum(@RequestParam(required = false, value = "companyCode") String companyCode) {
        return CommonResponseUtil.success(iFireFightingSystemService.getSystemAlarmInfoNum(companyCode));
    }
}
