package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.feign.morphic.model.ResourceDTO;
import com.yeejoin.equipmanage.common.entity.RiskSourceScene;
import com.yeejoin.equipmanage.common.entity.vo.PersonVo;
import com.yeejoin.equipmanage.common.entity.vo.PointTreeVo;
import com.yeejoin.equipmanage.common.entity.vo.RiskSourceTreeVO;
import com.yeejoin.equipmanage.common.response.RiskSourceTreeResponse;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
public interface IRiskSourceSceneService extends IService <RiskSourceScene> {
    /**
     * 获得区域树
     * @param orgCode
     * @return
     */
    List<RiskSourceTreeResponse> getAreaTree(String orgCode);

    /**
     * 获得点位区域树
     * @param orgCode
     * @return
     */
    List<PointTreeVo> getPointTree(String orgCode);

    /**
     * 获得点位区域重点设备树
     * @param orgCode
     * @return
     */
    List<PointTreeVo> getImportantEquip(String orgCode);
    /**
     * 创建画布
     * @param model 模型
     * @return RiskSourceScene
     */
    RiskSourceScene createModel(RiskSourceScene model);

    /**
     * 更新画布
     * @param resourceDTO 参数
     */
    ResourceDTO updateMorphic(ResourceDTO resourceDTO);

    /**
     * 查询组态用到的接口对象
     * @param dictCode 字典
     * @return 对象
     */
    Object queryDictMap(String dictCode);

    /**
     * 分页查询部件
     * @param page 分页对象
     * @param partType 部件类型
     * @param name 部件名称
     * @param code 部件编码
     * @return 分页对象
     */
    IPage queryPartListPage(Page page, Long partType, String name, String code);

    /**
     * 部件类型列表
     * @return List
     */
    List queryPartType();

    /**
     * 查询对应的场景关系表
     * @param riskSourceId 风险id
     * @param orgCode 组织机构
     * @return RiskSourceScene
     */
    RiskSourceScene getOneByUniqueKey(Long riskSourceId, String orgCode);

    /**
     * 获取所有风险点
     */
    List<RiskSourceTreeVO> findRiskSourceTrees(String compCode);

    /**
     * 执勤信息查询
     * @return
     */
    List<PersonVo> getPersonInfo();

    /**
     * 获取前四个视频
     * @return
     */
    List<RiskSourceTreeVO> getFourVideo();

    /**
     * 保存区域树画布
     * @return
     */
//    String  saveMorphic( PointTreeVo PointTreeVo);

    /**
     * 获取点位图预览信息
     */
    Map<String ,Object>  getSceneData(PointTreeVo vo, String orgCode);

    /**
     * 首页区域图id
     */
    Map<String, Object>  getFirstCanvas(String orgCode );
    /**
     * 获取区域名称
     */
    String  getSceneName(String id );
    
    List< Map<String ,Object>> queryRiskSourceSecondLevel();
    
    
    Map<String,Object> getSafetyIndexInfoByDate();
    /**
     * 获取系统菜单
     */
    List<PointTreeVo>  getSystemmeanLsit();


    List<Map> getstatus(String sceneId);
	    /**
     * 分页查询部件
     * @param page 分页对象
     * @param riskSourceId 风险区域ID
     * @return 分页对象
     */
    IPage getEquipBySourceId(Page page, String riskSourceId, String categoryId,String equipCode,String equipName,String companyId);

}
